#ifndef _ECS_VEC_H_
#define _ECS_VEC_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees aux structures `ecs_vec_int_t' et `ecs_vec_real_t' decrivant
 *   les vecteurs indexes entier et reel
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"
#include "ecs_vec_real_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui determine un nouveau vecteur a partir d'un vecteur donne
 *   en extrayant de ce dernier les elements selectionnes
 *   par le tableau de booleens
 *
 *  Cette fonction renvoie le vecteur qui definit les anciens elements du
 *   vecteur de reference en fonction des nouveaux elements du vecteur renvoye
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_real__extrait
(
       ecs_vec_real_t *const vec_new         ,
 const ecs_vec_real_t *const vec_ref         ,
 const ecs_tab_bool_t        bool_elt_select
) ;


#endif /* _ECS_VEC_H_ */
