#ifndef _ECS_VEC_DEF_PERIO_H_
#define _ECS_VEC_DEF_PERIO_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes aux structures `ecs_vec_int_t' et `ecs_vec_real_t' dcrivant
 *   les vecteurs indexs entier et rel
 *   et propres aux vecteurs indexs
 *      lies aux champs principaux de type "dfinition"
 *  Ces fonctions participent  la fonctionnalit de "priodicit"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_param_perio_glob.h"
#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"
#include "ecs_vec_real_publ.h"



/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------*
 *  Calcul de la matrice d'une rotation dfinie par un angle theta (en
 *   radians) et un vecteur unitaire direction.
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__mat_rot_3d
(
 ecs_real_t  angle,              /* --> Angle de rotation en degres           */
 ecs_real_t  direction[3],       /* --> Vecteur directeur (unitaire) de l'axe */
 ecs_real_t  matrice[3][3]       /* <-- Matrice definissant la rotation       */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui duplique les faces slectionnes pour la priodicit
 *  ainsi que les artes et sommets associs. Les distances maximales
 *  associes aux sommets sont aussi dupliques
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__duplique_def
(
       ecs_vec_int_t        *const  vec_def_fac,
       ecs_vec_int_t        *const  vec_def_are,
       ecs_vec_real_t       *const  vec_def_som,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
 const ecs_tab_int_t             *  tab_fac_select,
       ecs_tab_real_t            *  dist_max_som,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui duplique les normales aux faces priodiques dupliques.
 *
 *  La taille du tableau normale_fac est double (elle doit initialement
 *  correspondre au nombre de faces slectionnes, donc au nombre de valeurs
 *  non nulles de vec_fac_perio).
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__duplique_norm
(
 const ecs_vec_int_t        *const  vec_fac_perio,
 const ecs_param_perio_t            param_perio,
       float              * *       normale_fac
) ;


/*----------------------------------------------------------------------------
 *  Traitement spcifique pour la priodicit de rotation de 180 degrs
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__trait_spec_sym
(
       ecs_vec_real_t     * *const  vec_def_som,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
 const ecs_tab_int_t                liste_som_new,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui hrite le recollement dans le cas d'une priodicit
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__herite
(
       ecs_vec_int_t      * *const  vec_def_fac,
       ecs_vec_int_t      * *const  vec_def_are,
       ecs_vec_real_t     * *const  vec_def_som,
       ecs_vec_int_t        *const  vec_fac_old_new,
       ecs_vec_int_t        *const  vec_are_old_new,
       ecs_vec_int_t        *const  vec_som_old_new,
       ecs_vec_int_t      * *const  vec_fac_perio,
       ecs_vec_int_t      * *const  vec_are_perio,
       ecs_vec_int_t      * *const  vec_som_perio,
       ecs_tab_int_t        *const  liste_fac_err,
       ecs_tab_int_t        *const  liste_som_new,
 const ecs_param_perio_t            param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui nettoie les lments dupliqus n'ayant pas particip au
 *  recollement priodique
 *
 *  Attention : cette fonction doit tre appelle un nombre pair de fois
 *              (deux fois par priodicit) et contient un compteur statique
 *              gal au nombre d'appels modulo 2 + 1  cet effet.
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__nettoie
(
       ecs_vec_int_t    * *const  vec_def_fac,
       ecs_vec_int_t    * *const  vec_def_are,
       ecs_vec_real_t   * *const  vec_def_som,
       ecs_vec_int_t      *const  vec_fac_old_new,
       ecs_vec_int_t      *const  vec_are_old_new,
       ecs_vec_int_t      *const  vec_fac_perio,
       ecs_vec_int_t      *const  vec_are_perio,
       ecs_vec_int_t      *const  vec_som_perio,
       ecs_tab_int_t      *const  liste_fac_err,
       ecs_tab_int_t      *const  liste_som_new,
 const ecs_param_perio_t          param_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met  jour la renumrotation
 *  "lments initiaux -> lments priodiques" en fonction d'un champ
 *  "lments prcdents -> nouveaux lments" en cas de modifications
 *  successives de la dfinition des lments
 *  On modifie a la fois 'val_tab' et on dcale 'pos_tab'.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__maj_elt_perio
(
 ecs_vec_int_t  *const vec_elt_perio,
 ecs_vec_int_t  *const vec_elt_old_new,
 size_t                nbr_elt_new
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui met  jour le tableau renvoy par
 * ecs_vec_def__typ_fac_cel() en fonction d'une connectivit ajoute par
 * une priodicit.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__typ_fac_perio
(
 ecs_vec_int_t  * vec_fac_perio,
 ecs_tab_int_t  * typ_fac
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui compte le nombre d'lments priodiques.
 *  On vrifie qu'un lment priodique ne se voit pas lui-mme (cela
 *  peut arriver dans le cas d'une priodicit de rotation de 180 degrs)
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_vec_def__compte_elt_perio
(
 const ecs_vec_int_t  * vec_elt_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit la des faces priodiques associes  une
 *  priodicit num_per de la manire suivante :
 *  =>  [i,j; ...] avec i->j
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_def__liste_fac_perio
(
 const ecs_vec_int_t  * vec_elt_perio
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui liste parmi les faces priodiques celles qui se "voient"
 *  elles-mmes (i.e  "i -> i").
 *----------------------------------------------------------------------------*/

void ecs_vec_def_perio__lis_fac_err
(
 const ecs_vec_int_t   *const vec_fac_perio,
       ecs_tab_int_t   *const liste_fac_err
) ;


#endif /* _ECS_VEC_DEF_PERIO_H_ */
