#ifndef _ECS_VEC_INT_PRIV_H_
#define _ECS_VEC_INT_PRIV_H_

/*============================================================================
 *  Definition privee de la structure `ecs_vec_int_t' decrivant
 *   un vecteur indexe entier
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"


/*============================================================================
 *                       Definition de macros
 *============================================================================*/


/*============================================================================
 *                       Definition de la structure
 *============================================================================*/

struct _ecs_vec_int_t {

  size_t       pos_nbr ;  /* Nombre   de  positions                           */
  ecs_size_t  *pos_tab ;  /* Tableau  des positions                           */
  ecs_int_t   *val_tab ;  /* Tableau  des valeurs                             */

} ;


#endif /* _ECS_VEC_INT_PRIV_H_ */
