#ifndef _ECS_VEC_INT_TRI_H_
#define _ECS_VEC_INT_TRI_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_vec_int_t' dcrivant un vecteur indxe entier
 *   et ralisant des fonctionnalits de tri
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui trie un vecteur d'entiers en renvoyant :
 *  - le vecteur tri ;
 *  - le vecteur de renumrotation qui permet de passer
 *     du vecteur tri au vecteur initial
 *----------------------------------------------------------------------------*/

void ecs_vec_int__trie_et_renvoie
(
 const ecs_vec_int_t *const this_vec       , /* --> Entiers  trier           */
       ecs_vec_int_t *const vec_trie       , /* <-- Entiers tris             */
       ecs_tab_int_t *const vect_renum_pos   /* <-> Renumrotation positions  */
) ;


#endif /* _ECS_VEC_INT_TRI_H_ */
