#ifndef _ECS_CGNS_DEF_H_
#define _ECS_CGNS_DEF_H_

/*============================================================================
 *  Dfinitions de macros et constantes
 *   servant  la lecture d'un fichier de maillage au format CGNS
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"

#if defined(HAVE_CGNS)


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "CGNS"
 *----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

#include <cgnslib.h>

#ifdef __cplusplus
}
#endif


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                       Dfinition de macros
 *                       Definition de constantes globales statiques
 *============================================================================*/


/* Dfinition des lments */
/*=========================*/

/* Tableau donnant la liste des lments              */
/* `paraboliques' ou `cubiques'                       */
/* qui sont transforms en leur equivalent `linaire' */
/* -------------------------------------------------- */

#define ECS_CGNS_NBR_TYP_ELT                               20
#define ECS_CGNS_NBR_MAX_SOM                                8

typedef struct {

  ElementType_t   cgns_type  ; /* Type CGNS de l'lment         */
  ecs_elt_typ_t   ecs_type   ; /* Type ECS  de l'lment         */
  ecs_int_t       nbr_som    ; /* Nombre de sommets associs     */
  ecs_int_t       num_som[ECS_CGNS_NBR_MAX_SOM] ; /* Sommets ECS */

} ecs_cgns_elt_t ;


/* Le tableau suivant est donn dans le mme ordre que les dfinitions */
/* de cgnslib.h (mais ne contient pas les deux premires entres)      */

static const ecs_cgns_elt_t
ecs_cgns_elt_liste_c[ECS_CGNS_NBR_TYP_ELT] = {
  {                                /* 1 */
    NODE                                 ,
    ECS_ELT_TYP_SOM                      ,
    1                                    ,
    { 1 }
  } ,
  {                                /* 2 */
    BAR_2                                ,
    ECS_ELT_TYP_ARE                      ,
    2                                    ,
    { 1, 2 }
  } ,
  {                                /* 3 */
    BAR_3                                ,
    ECS_ELT_TYP_ARE                      ,
    3                                    ,
    { 1, 2 }
  } ,
  {                                /* 4 */
    TRI_3                                ,
    ECS_ELT_TYP_FAC_TRIA                 ,
    3                                    ,
    { 1, 2, 3 }
  } ,
  {                                /* 5 */
    TRI_6                                ,
    ECS_ELT_TYP_FAC_TRIA                 ,
    6                                    ,
    { 1, 2, 3 }
  } ,
  {                                /* 6 */
    QUAD_4                               ,
    ECS_ELT_TYP_FAC_QUAD                 ,
    4                                    ,
    { 1, 2, 3, 4 }
  } ,
  {                                /* 7 */
    QUAD_8                               ,
    ECS_ELT_TYP_FAC_QUAD                 ,
    8                                    ,
    { 1, 2, 3, 4 }
  } ,
  {                                /* 8 */
    QUAD_9                               ,
    ECS_ELT_TYP_FAC_QUAD                 ,
    9                                    ,
    { 1, 2, 3, 4 }
  } ,
  {                                /* 9 */
    TETRA_4                              ,
    ECS_ELT_TYP_CEL_TETRA                ,
    4                                    ,
    { 1, 2, 3, 4 }
  } ,
  {                               /* 10 */
    TETRA_10                             ,
    ECS_ELT_TYP_CEL_TETRA                ,
    10                                   ,
    { 1, 2, 3, 4 }
  } ,
  {                               /* 11 */
    PYRA_5                               ,
    ECS_ELT_TYP_CEL_PYRAM                ,
    5                                    ,
    { 1, 2, 3, 4, 5 }
  } ,
  {                               /* 12 */
    PYRA_14                              ,
    ECS_ELT_TYP_CEL_PYRAM                ,
    14                                   ,
    { 1, 2, 3, 4, 5 }
  } ,
  {                               /* 13 */
    PENTA_6                              ,
    ECS_ELT_TYP_CEL_PRISM                ,
    6                                    ,
    { 1, 2, 3, 4, 5, 6 }
  } ,
  {                               /* 14 */
    PENTA_15                             ,
    ECS_ELT_TYP_CEL_PRISM                ,
    15                                   ,
    { 1, 2, 3, 4, 5, 6 }
  } ,
  {                               /* 15 */
    PENTA_18                             ,
    ECS_ELT_TYP_CEL_PRISM                ,
    18                                   ,
    { 1, 2, 3, 4, 5, 6 }
  } ,
  {                               /* 16 */
    HEXA_8 ,
    ECS_ELT_TYP_CEL_HEXA                 ,
    8                                    ,
    { 1, 2, 3, 4, 5, 6, 7, 8 }           ,
  } ,
  {                               /* 17 */
    HEXA_20                              ,
    ECS_ELT_TYP_CEL_HEXA                 ,
    20                                   ,
    { 1, 2, 3, 4, 5, 6, 7, 8 }           ,
  } ,
  {                               /* 18 */
    HEXA_27                              ,
    ECS_ELT_TYP_CEL_HEXA                 ,
    27                                   ,
    { 1, 2, 3, 4, 5, 6, 7, 8 }           ,
  } ,
  {                               /* 19 */
    MIXED                                ,
    ECS_ELT_TYP_NUL                      ,
    0                                    ,
    { 0 }                                ,
  } ,
  {                               /* 20 */
    NGON_n                               ,
    ECS_ELT_TYP_FAC_POLY                 ,
    0                                    ,
    { 0 }
  }
} ;

#endif /* HAVE_CGNS */

#endif /* _ECS_CGNS_DEF_H_ */
