#ifndef _ECS_ENTMAIL_NOYAU_H_
#define _ECS_ENTMAIL_NOYAU_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_entmail_t' dcrivant une entit de maillage
 *   et ralisant les sorties pour l'interfacage avec le Noyau du Code Saturne
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_comm.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"
#include "ecs_param_perio_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fonction qui crit le fichier d'interface pour le Noyau de Code_Saturne.
 *----------------------------------------------------------------------------*/

void ecs_entmail_ncs__ecr
(
 ecs_bool_t                      simulate,
 ecs_entmail_t     *const *const vect_entmail,
 ecs_famille_t     *const *const vect_fam_tete,
 ecs_param_perio_t        *const liste_param_perio
) ;


#endif /* _ECS_ENTMAIL_NOYAU_H_ */
