#ifndef _ECS_ENTMAIL_POST_H_
#define _ECS_ENTMAIL_POST_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_entmail_t' dcrivant une entit de maillage
 *   et ralisant les sorties pour post-traitement
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/

#include "ecs_post_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction crivant les connectivits des lments
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_elt
(
 const char            *const nom_maillage,
       int                    dim_entite_max,
 const ecs_entmail_t   *const entmail_elt,
 const ecs_entmail_t   *const entmail_inf,
 const ecs_entmail_t   *const entmail_som,
 const ecs_famille_t   *const famille_elt,
 const ecs_famille_t   *const famille_inf,
       ecs_post_type_t        type_post,
       ecs_post_t      *const cas_post
) ;


/*----------------------------------------------------------------------------
 *  Impression d'une variable en post-traitement valant 1 pour les entits
 *  enumres dans cette liste, 0 pour les autres
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_tab_liste
(
       ecs_entmail_t   *const this_entmail,
 const char            *const nom_maillage,
 const char            *const nom_var,
 const ecs_tab_int_t          liste_entites,
       ecs_post_t      *const cas_post
) ;


/*----------------------------------------------------------------------------
 *  Impression d'un tableau de variables en post-traitement.
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_tab_int
(
 const char           *const nom_maillage,
 const char           *const nom_var,
       ecs_tab_int_t  *const tab_val,
       ecs_post_t     *const cas_post
) ;


#endif /* _ECS_ENTMAIL_POST_H_ */
