#ifndef _ECS_CHRONO_H_
#define _ECS_CHRONO_H_

/*============================================================================
 *  Prototypes des fonctions
 *   de calcul et d'affichage de temps d'xcution (chronomtrie)
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <string.h>

#include <bft_mem.h>
#include <bft_timer.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/

#define ECS_CHRONO(str) \
(BFT_REALLOC(_ecs_chrono_temps,                                       \
             _ecs_chrono_id + 1, double)                            , \
 BFT_REALLOC(_ecs_chrono_nom  ,                                       \
             _ecs_chrono_id + 1, char *)                            , \
 BFT_MALLOC(_ecs_chrono_nom[_ecs_chrono_id], strlen(str) + 1, char) , \
 strcpy(_ecs_chrono_nom[_ecs_chrono_id], str)                       , \
 _ecs_chrono_cpu = bft_timer_cpu_time()                             , \
 _ecs_chrono_temps[_ecs_chrono_id] =   _ecs_chrono_cpu                \
                                     - _ecs_chrono_cpu_prec         , \
 _ecs_chrono_cpu_prec = _ecs_chrono_cpu                             , \
 _ecs_chrono_id++                                                    )


/*============================================================================
 *                       Dclaration de variables globales
 *============================================================================*/

extern size_t     _ecs_chrono_id ;
extern char    ** _ecs_chrono_nom ;
extern double   * _ecs_chrono_temps ;
extern double     _ecs_chrono_cpu ;
extern double     _ecs_chrono_cpu_prec ;


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *    Fonction qui initialise les temps de rfrence
 *----------------------------------------------------------------------------*/

void ecs_chrono__initialise(void) ;


/*----------------------------------------------------------------------------
 *    Fonction qui affiche les temps d'excution et termine la chronomtrie
 *----------------------------------------------------------------------------*/

void ecs_chrono__affiche(void) ;


#endif /* _ECS_CHRONO_H_ */
