dnl Copyright (C) 2005-2008 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the COPYING file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_METIS
#-----------------
# modifies or sets have_metis, METIS_CPPFLAGS, METIS_LDFLAGS, and METIS_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_METIS], [

have_metis=no

AC_ARG_ENABLE(metis,
  [  --disable-metis         do not use METIS when available],
  [
    case "${enableval}" in
      yes) metis=true ;;
      no)  metis=false ;;
      *)   AC_MSG_ERROR([bad value ${enableval} for --enable-metis]) ;;
    esac
  ],
  [ metis=true ]
)

AC_ARG_WITH(metis,
  [  --with-metis=PATH       specify prefix directory for METIS],[
])
AC_ARG_WITH(metis-include,
  [  --with-metis-include=PATH  specify directory for METIS include files],[
])
AC_ARG_WITH(metis-lib,
  [  --with-metis-lib=PATH   specify directory for METIS library],[
])

if test "x$metis" = "xtrue" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$with_metis_include" != "x" ; then
    METIS_CPPFLAGS="-I$with_metis_include"
  elif test "x$with_metis" != "x" ; then
    METIS_CPPFLAGS="-I$with_metis/include"
  fi
  if test "x$with_metis_lib" != "x" ; then
    METIS_LDFLAGS="-L$with_metis_lib"
  elif test "x$with_metis" != "x" ; then
    METIS_LDFLAGS="-L$with_metis/lib"
  fi

  METIS_LIBS="-lmetis -lm"
  CPPFLAGS="${CPPFLAGS} ${METIS_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${METIS_LDFLAGS}"
  LIBS="${LIBS} ${METIS_LIBS}"

  AC_CHECK_HEADERS([metis.h],
                   [], 
                   [ AC_MSG_WARN([METIS header not found or usable])
                   ],
                   []
                  )

  AC_CHECK_LIB(metis, METIS_PartGraphKway, 
               [ AC_DEFINE([HAVE_METIS], 1, [use METIS ])
                 have_metis=yes
               ], 
               [ AC_MSG_WARN([do not use METIS])
               ],
               )

  if test "x$have_metis" = "xno"; then

    LIBS="$saved_LIBS"
    METIS_LIBS="-lscotchmetis -lscotch -lscotcherr -lm"
    LIBS="${LIBS} ${METIS_LIBS}"

    AC_CHECK_LIB(scotchmetis, METIS_PartGraphKway, 
                 [ AC_DEFINE([HAVE_SCOTCH_METIS], 1, [use SCOTCH METIS ])
                   AC_DEFINE([HAVE_METIS], 1, [do as if using METIS])
                   have_metis=yes
                 ], 
                 [ AC_MSG_WARN([do not use SCOTCH METIS])
                 ],
                 )

  fi

  if test "x$have_metis" = "xno"; then
    METIS_CPPFLAGS=""
    METIS_LDFLAGS=""
    METIS_LIBS=""
  fi

fi

AM_CONDITIONAL(HAVE_METIS, test x$have_metis = xyes)

CPPFLAGS="$saved_CPPFLAGS"
LDFLAGS="$saved_LDFLAGS"
LIBS="$saved_LIBS"

unset saved_CPPFLAGS
unset saved_LDFLAGS
unset saved_LIBS

AC_SUBST(METIS_CPPFLAGS)
AC_SUBST(METIS_LDFLAGS)
AC_SUBST(METIS_LIBS)

])dnl

