#ifndef _ECS_ENTMAIL_PRIV_H_
#define _ECS_ENTMAIL_PRIV_H_

/*============================================================================
 *  Définition privée de la structure `_ecs_entmail_t' décrivant
 *   une entité de maillage
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_champ.h"

/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail.h"


/*============================================================================
 *                       Définition de macros
 *============================================================================*/


/*============================================================================
 *                       Définition de la structure
 *============================================================================*/

struct _ecs_entmail_t {

  ecs_champ_t        * champ[ECS_CHAMP_FIN] ;  /* Vecteur des pointeurs sur   */
                                               /* les têtes des listes        */
                                               /* chaînées de champs          */

} ;


/*============================================================================
 *
 *                   Tableau des listes chaînées de champs
 *
 *  --------------------------------------------------------------------------
 *  champs "principaux"  (obligatoirement définis pour une entité de maillage)
 *  --------------------------------------------------------------------------
 *
 *  champ  "définition"        - Identificateur `ECS_CHAMP_DEF'
 *                             - Liste chaînée réduite à 1 champ + NULL
 *                             - Le champ contient la définition
 *                                des éléments de l'entité de maillage courante
 *                               en fonction
 *                                des éléments d'une entité de maillage
 *                                de dimension inférieure
 *
 *  champ  "type geométrique"  - Identificateur `ECS_CHAMP_TYP'
 *                             - Obligatoire uniquement pour les cellules
 *                             - Liste chaînée réduite à 1 champ + NULL
 *                             - Le champ contient le type géometrique
 *                                des éléments
 *                               (arête, triangle, quadrilatère, tétraèdre,
 *                                prisme, hexaèdre, etc.)
 *
 *  --------------------------------------------------------------------------
 *  champs "auxiliaires" (éventuellement  définis pour une entité de maillage)
 *  --------------------------------------------------------------------------
 *
 *  champs "attribut"          - Identificateur `ECS_CHAMP_ATT'
 *                             - Liste chaînée pouvant avoir un nombre
 *                                quelconque de noeuds
 *                             - La liste contient les attributs qui peuvent
 *                                etre attachés aux éléments
 *                               À chaque attribut correspond un champ
 *                               Exemples:
 *                               . attribut "couleur"     des éléments,
 *                               . attribut "groupe"
 *                                  auquels appartiennent les éléments,
 *                               . attribut "etiquettes"  des éléments,
 *                               . attribut "filiation"   des éléments,
 *                               . etc.
 *
 *============================================================================*/


#endif /* _ECS_ENTMAIL_PRIV_H_ */

