#ifndef _ECS_FAMILLE_H_
#define _ECS_FAMILLE_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associées à la structure `ecs_famille_t' décrivant une famille
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/

/*---------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_descr.h"


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                         Déclaration de la structure
 *============================================================================*/

typedef struct _ecs_famille_t ecs_famille_t;


/*============================================================================
 *                         Définition d'enumération
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Définition d'énumération liée au tableau des familles
 *-------------------------------------------------------*/

typedef enum {

  ECS_FAMILLE_SOM,   /* Entite sommet               */
  ECS_FAMILLE_FAC,   /* Entite face                 */
  ECS_FAMILLE_CEL,   /* Entite cellule              */
  ECS_FAMILLE_FIN    /* Nombre des entites definies */

} ECS_FAMILLE_E;


#define ECS_FAMILLE_DEB  ECS_FAMILLE_SOM


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*---------------------------------------------------------------------------
 *    Fonction de création d'une structure de famille `ecs_famille_t'
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__cree
(
 ecs_int_t          num,                /* --> Numéro de la famille           */
 ecs_descr_t *const descr_tete          /* --> Tête de la liste chaînée       */
                                        /*      de descripteurs d'attributs   */
);


/*---------------------------------------------------------------------------
 *  Fonction libérant la structure `ecs_famille_t' donnée en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__detruit
(
 ecs_famille_t * this_fam
);


/*---------------------------------------------------------------------------
 *  Fonction imprimant le contenu d'une structure `ecs_famille_t' donnée
 *   sur le flux décrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_famille__imprime
(
 const ecs_famille_t *const this_fam,           /* --> Structure à imprimer   */
       ecs_int_t            imp_col,
       bft_file_t    *const fic_imp             /* --> Descripteur du fichier */
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets d'une structure `ecs_famille_t'
 *----------------------------------------------------------------------------*/

float ecs_famille__ret_taille
(
  const ecs_famille_t *const this_fam
);


/*----------------------------------------------------------------------------
 *  Fonction qui alloue une structure `ecs_famille_t' et qui remplit
 *   son contenu en copiant le contenu de la structure donnée en argument
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__copie
(                                     /* <-- Renvoie la structure copiée      */
 ecs_famille_t * this_famille         /* --> Structure à copier               */
);


/*----------------------------------------------------------------------------
 *  Fonction qui affiche la définition de la famille
 *----------------------------------------------------------------------------*/

void ecs_famille__affiche
(
 const ecs_famille_t *const this_fam
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des identificateurs des
 *   descripteurs de la famille donnée en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_famille__ret_ide
(
 const ecs_famille_t *const this_fam
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des des pointeurs sur les noms
 *   des descripteurs de la famille donnée en argument
 *----------------------------------------------------------------------------*/

ecs_tab_char_t ecs_famille__ret_nom
(
 const ecs_famille_t *const this_fam
);


/*----------------------------------------------------------------------------
 *  Fonction qui construit les 2 listes chaînées de descripteurs
 *   de type "couleur" et "groupe" à partir de la famille donnée
 *----------------------------------------------------------------------------*/

void ecs_famille__cree_descr
(
 ecs_famille_t   *const this_fam,
 ecs_descr_t   * *const descr_tete_couleur,
 ecs_descr_t   * *const descr_tete_groupe
);


#endif /* _ECS_FAMILLE_H_ */
