#ifndef _ECS_VEC_INT_ATT_H_
#define _ECS_VEC_INT_ATT_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associées à la structure `ecs_vec_int_t' décrivant un vecteur indexé entier
 *   et propres aux vecteurs indexés
 *      liés aux champs auxiliaires de type "attribut"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui assemble :
 *  - une table de positions donnée dans une table de positions réceptrice
 *  - la table des valeurs correspondante dans la table des valeurs réceptrice
 *
 *  Les 2 tables de positions doivent avoir le même nombre de positions
 *  (et les tables de valeurs doivent être de même type !)
 *
 *  Seule la table réceptrice est modifiée,
 *   la table à assembler reste inchangée
 * ----------------------------------------------------------------------------
 *
 *  Exemple : (pour des tables de valeurs entières)
 *  =======
 *
 *  Soit la table à assembler :
 *
 *                         .---.---..---..---.---.---.
 *     assemb->val_tab     | 5 | 3 || 4 || 5 | 2 | 6 |
 *                         `---'---'`---'`---'---'---'
 *                           0   1    2    3   4   5
 *
 *
 *                         .---.---.---.---.---.
 *     assemb->pos_tab     | 1 | 3 | 4 | 4 | 7 |
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *
 *  dans la table réceptrice :
 *
 *                         .---..---..---.---..---.
 *     recept->val_tab     | 4 || 5 || 6 | 6 || 1 |
 *                         `---'`---'`---'---'`---'
 *                           0    1    2   3    4
 *
 *
 *                         .---.---.---.---.---.
 *     recept->pos_tab     | 1 | 2 | 3 | 5 | 6 |
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *
 *  La table réceptrice devient :
 *
 *                         .---.---.---..---.---..---.---..---.---.---.---.
 *     recept->val_tab     | 4 | 5 | 3 || 5 | 4 || 6 | 6 || 1 | 5 | 2 | 6 |
 *                         `---'---'---'`---'---'`---'---'`---'---'---'---'
 *                           0   1   2    3   4    5   6    7   8   9   10
 *
 *
 *                         .---.---.---.---.---.
 *     recept->pos_tab     | 1 | 4 | 6 | 8 | 12|
 *                         `---'---'---'---'---'
 *                           0   1   2   3   4
 *
 *----------------------------------------------------------------------------*/

void ecs_vec_int_att__assemble
(
 ecs_vec_int_t *const vec_int_recept,
 ecs_vec_int_t *const vec_int_assemb
) ;


/*----------------------------------------------------------------------------
 *  Fonction réalisant la transformation d'un vecteur indexé
 *   en fusionnant les propriétés de ses éléments
 *   qui sont identiquement transformés par le vecteur de transformation donné
 *----------------------------------------------------------------------------*/

void ecs_vec_int_att__fusionne
(
       ecs_vec_int_t *const this_vec_int,
       size_t               nbr_elt_new,
 const ecs_tab_int_t        vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numéros de famille des éléments
 *
 *  Pour les éléments de famille 0 ou n'ayant pas de famille, on leur
 *   attribue le numéro de famille par défaut
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__fam_elt
(
 ecs_vec_int_t  *const this_vec_int_fam,
 ecs_tab_int_t  *const tab_nbr_elt_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des numéros de famille
 *   des éléments filtrés par la liste optionnelle donnée en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__liste_elt_fam
(
       ecs_vec_int_t   *const this_vec_int_fam,
 const ecs_tab_int_t   *const liste_filtre,
 const ecs_tab_bool_t  *const indic_famille
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui comptabilise, pour chaque valeur d'attribut,
 *   les nombres d'éléments ayant la meme valeur d'attribut
 *----------------------------------------------------------------------------*/

ecs_int_t * ecs_vec_int_att__cpt_elt_val
(
 const ecs_vec_int_t  *const vec_int_att,
       size_t                nbr_val_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui crée une liste d'éléments ayant pour valeur de l'attribut
 *   la valeur donnée en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__cree_liste
(
 ecs_vec_int_t  *const vec_int_att,
 int                   valeur_att
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui remplace les références à des éléments
 *  en des références à d'autres éléments liés aux premiers
 *  par un vecteur indexé contenant des valeurs positives mais pouvant
 *  contenir la valeur 0
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_int__ret_remplace_ref_att
(
       ecs_vec_int_t *const vec_rep,
 const ecs_vec_int_t *const vec_def
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renumérote à partir de `1' les références
 *   des numéros de descripteurs
 *   dans le tableau des valeurs d'un attribut donné
 *
 *  La fonction renvoie un tableau de renumérotation des descripteurs
 *   d'un attribut de référence donné
 *   Si le numéro de descripteur n'a pas été renumérote, on lui attribue
 *    la valeur `num_descr_defaut' dans le tableau de renumérotation
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_vec_int_att__renum_descr
(
       ecs_vec_int_t  *const vec_att,
 const ecs_int_t             num_descr_defaut,
       size_t                nbr_descr_old
) ;


#endif /* _ECS_VEC_INT_ATT_H_ */
