dnl Copyright (C) 2005-2009 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the COPYING file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_METIS
#-----------------
# modifies or sets have_metis, METIS_CPPFLAGS, METIS_LDFLAGS, and METIS_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_METIS], [

have_metis=no

AC_ARG_WITH(metis,
            [AS_HELP_STRING([--with-metis=PATH],
                            [specify prefix directory for METIS])],
            [if test "x$withval" = "x"; then
               with_metis=yes
             fi],
            [with_metis=check])

AC_ARG_WITH(metis-include,
            [AS_HELP_STRING([--with-metis-include=PATH],
                            [specify directory for METIS include files])],
            [if test "x$with_metis" = "xcheck"; then
               with_metis=yes
             fi
             METIS_CPPFLAGS="-I$with_metis_include"],
            [if test "x$with_metis" != "xno" -a "x$with_metis" != "xyes" \
	          -a "x$with_metis" != "xcheck"; then
               METIS_CPPFLAGS="-I$with_metis/include"
             fi])

AC_ARG_WITH(metis-lib,
            [AS_HELP_STRING([--with-metis-lib=PATH],
                            [specify directory for METIS library])],
            [if test "x$with_metis" = "xcheck"; then
               with_metis=yes
             fi
             METIS_LDFLAGS="-L$with_metis_lib"],
            [if test "x$with_metis" != "xno" -a "x$with_metis" != "xyes" \
	          -a "x$with_metis" != "xcheck"; then
               METIS_LDFLAGS="-L$with_metis/lib"
             fi])


if test "x$with_metis" != "xno" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  METIS_LIBS="-lmetis -lm"
  CPPFLAGS="${CPPFLAGS} ${METIS_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${METIS_LDFLAGS}"
  LIBS="${LIBS} ${METIS_LIBS}"

  AC_CHECK_HEADERS([metis.h],
                   [], 
                   [ AC_MSG_WARN([METIS header not found or usable])
                   ],
                   []
                  )

  AC_CHECK_LIB(metis, METIS_PartGraphKway, 
               [ AC_DEFINE([HAVE_METIS], 1, [use METIS ])
                 have_metis=yes
               ],
               [ if test "x$with_metis" != "xcheck" ; then
                   AC_MSG_FAILURE([METIS support is requested, but test for METIS failed!])
                 else
                   AC_MSG_WARN([do not use METIS])
                 fi
               ]
               )

  if test "x$have_metis" = "xno"; then
    METIS_LIBS=""
  fi

fi

AM_CONDITIONAL(HAVE_METIS, test x$have_metis = xyes)

CPPFLAGS="$saved_CPPFLAGS"
LDFLAGS="$saved_LDFLAGS"
LIBS="$saved_LIBS"

unset saved_CPPFLAGS
unset saved_LDFLAGS
unset saved_LIBS

AC_SUBST(METIS_CPPFLAGS)
AC_SUBST(METIS_LDFLAGS)
AC_SUBST(METIS_LIBS)

])dnl

