/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009, 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "annotations_dock.h"



UI_Annotationswindow::UI_Annotationswindow(int file_number, QWidget *parent)
{
  QPalette palette;


  mainwindow = (UI_Mainwindow *)parent;

  file_num = file_number;

  docklist = new QDockWidget("Annotations", parent);
  docklist->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea);
  docklist->setFeatures(QDockWidget::DockWidgetClosable | QDockWidget::DockWidgetMovable);

  palette.setColor(QPalette::Text, mainwindow->maincurve->text_color);
  palette.setColor(QPalette::Base, mainwindow->maincurve->backgroundcolor);

  relative = 1;

  selected = -1;

  dialog1 = new QDialog;

  checkbox1 = new QCheckBox("Relative");
  checkbox1->setGeometry(2, 2, 10, 10);
  checkbox1->setTristate(FALSE);
  checkbox1->setCheckState(Qt::Checked);

  list = new QListWidget(dialog1);
  list->setFont(*mainwindow->monofont);
  list->setAutoFillBackground(TRUE);
  list->setPalette(palette);

  v_layout = new QVBoxLayout(dialog1);
  v_layout->addWidget(checkbox1);
  v_layout->addWidget(list);
  v_layout->setSpacing(1);

  docklist->setWidget(dialog1);

  updateList(file_num);

  QObject::connect(list,      SIGNAL(itemPressed(QListWidgetItem *)), this, SLOT(annotation_selected(QListWidgetItem *)));
  QObject::connect(docklist,  SIGNAL(visibilityChanged(bool)),        this, SLOT(hide_editdock(bool)));
  QObject::connect(checkbox1, SIGNAL(stateChanged(int)),              this, SLOT(checkbox1_clicked(int)));
}



void UI_Annotationswindow::checkbox1_clicked(int state)
{
  if(state==Qt::Checked)
  {
    relative = 1;
  }

  if(state==Qt::Unchecked)
  {
    relative = 0;
  }

  updateList(file_num);
}



void UI_Annotationswindow::hide_editdock(bool visible)
{
  if(visible==FALSE)
  {
    mainwindow->annotationEditDock->dockedit->hide();
  }
}



void UI_Annotationswindow::updateList(int file_num)
{
  char str[MAX_ANNOTATION_LEN + 16],
       *str_tmp;

  QListWidgetItem *listitem;

  QString string;

  QByteArray ba;

  int i,
      len,
      sequence_nr=0,
      jump=0,
      modified=0;


  selected = -1;


#ifdef Q_WS_X11
  QFont specialfont("andale mono", 12, QFont::Normal, TRUE);

  specialfont.setPixelSize(12);
#endif

#ifdef Q_WS_MAC
  QFont specialfont("andale mono", 12, QFont::Normal, TRUE);

  specialfont.setPixelSize(12);
#endif

#ifdef Q_WS_WIN
  QFont specialfont("courier", 11, QFont::Normal, TRUE);

  specialfont.setPixelSize(12);
#endif


  annotation = mainwindow->annotationlist[file_num];

  list->clear();

  edfplus_annotation_sort(&annotation);

  while(annotation)
  {
    string = QString::fromUtf8(annotation->annotation);

    ba = string.toUtf8();
    str_tmp = ba.data();

    len = 0;
    for(i=0; ; i++)
    {
      if(str_tmp[i]==0)  break;

      if(((((unsigned char *)str_tmp)[i])&224)==192)  len++;
    }

    for(i=0; i<len; i++)  string.append(' ');

    if(relative)
    {
      if(annotation->onset<0)
      {
        snprintf(str, (MAX_ANNOTATION_LEN + 16) / 2, "  -%i:%02i:%02i.%04i",
                (int)(((-annotation->onset / TIME_DIMENSION)/ 3600) % 24),
                (int)(((-annotation->onset / TIME_DIMENSION) % 3600) / 60),
                (int)((-annotation->onset / TIME_DIMENSION) % 60),
                (int)((-annotation->onset % TIME_DIMENSION) / 1000LL));
      }
      else
      {
        snprintf(str, (MAX_ANNOTATION_LEN + 16) / 2, "  %2i:%02i:%02i.%04i",
                (int)(((annotation->onset / TIME_DIMENSION)/ 3600) % 24),
                (int)(((annotation->onset / TIME_DIMENSION) % 3600) / 60),
                (int)((annotation->onset / TIME_DIMENSION) % 60),
                (int)((annotation->onset % TIME_DIMENSION) / 1000LL));
      }
    }
    else
    {
      snprintf(str, MAX_ANNOTATION_LEN + 16, "  %2i:%02i:%02i.%04i",
              (int)(((annotation->onset + mainwindow->edfheaderlist[file_num]->l_starttime) / TIME_DIMENSION)/ 3600),
              (int)((((annotation->onset + mainwindow->edfheaderlist[file_num]->l_starttime) / TIME_DIMENSION) % 3600) / 60),
              (int)(((annotation->onset + mainwindow->edfheaderlist[file_num]->l_starttime) / TIME_DIMENSION) % 60),
              (int)(((annotation->onset + mainwindow->edfheaderlist[file_num]->l_starttime) % TIME_DIMENSION) / 1000LL));
    }

    remove_trailing_zeros(str);

    if(string.size() < 20)
    {
      string = string.leftJustified(20, ' ');
    }

    string.append(QString::fromLatin1(str));

    listitem = new QListWidgetItem(string, list);

    if(annotation->modified==1)
    {
      listitem->setFont(specialfont);

      listitem->setForeground(Qt::red);

      modified = 1;
    }

    if(annotation->onset<0)
    {
      snprintf(str, (MAX_ANNOTATION_LEN + 16) / 2, "onset: -%i:%02i:%02i.%04i",
              (int)(((-annotation->onset / TIME_DIMENSION)/ 3600) % 24),
              (int)(((-annotation->onset / TIME_DIMENSION) % 3600) / 60),
              (int)((-annotation->onset / TIME_DIMENSION) % 60),
              (int)((-annotation->onset % TIME_DIMENSION) / 1000LL));
    }
    else
    {
      snprintf(str, (MAX_ANNOTATION_LEN + 16) / 2, "onset: %2i:%02i:%02i.%04i",
              (int)(((annotation->onset / TIME_DIMENSION)/ 3600) % 24),
              (int)(((annotation->onset / TIME_DIMENSION) % 3600) / 60),
              (int)((annotation->onset / TIME_DIMENSION) % 60),
              (int)((annotation->onset % TIME_DIMENSION) / 1000LL));
    }

    if(annotation->duration[0]!=0)
    {
      snprintf(str + strlen(str), (MAX_ANNOTATION_LEN + 16) / 2, "\nduration: %s",annotation->duration);
    }

    remove_trailing_zeros(str);

    strcat(str, "\n\n");

    string = QString::fromLatin1(str);

    string.append(QString::fromUtf8(annotation->annotation));

    listitem->setToolTip(string);

    if(annotation->selected)
    {
      selected = sequence_nr;

      annotation->selected = 0;

      if(annotation->jump)
      {
        jump = 1;

        annotation->jump = 0;
      }
    }

    annotation = annotation->next_annotation;

    sequence_nr++;
  }

  if(mainwindow->annot_editor_active)
  {
    if(selected>=0)
    {
      list->setCurrentRow(selected, QItemSelectionModel::ClearAndSelect);

      mainwindow->annotationEditDock->set_selected_annotation(file_num, selected);

      if(jump)
      {
        jump = 0;

        annotation_selected(list->currentItem());
      }

      selected = -1;
    }

    if(modified)
    {
      mainwindow->annotations_edited = 1;

      mainwindow->save_act->setEnabled(TRUE);
    }
  }
}



void UI_Annotationswindow::annotation_selected(QListWidgetItem * item)
{
  int i=0, n;

  long long temp;


  annotation = mainwindow->annotationlist[file_num];

  n = list->row(item);

  if(mainwindow->annot_editor_active)
  {
    mainwindow->annotationEditDock->set_selected_annotation(file_num, n);
  }

  while(n)
  {
    annotation = annotation->next_annotation;

    n--;
  }

  if(mainwindow->viewtime_sync==VIEWTIME_SYNCED_OFFSET)
  {
    for(i=0; i<mainwindow->files_open; i++)
    {
      mainwindow->edfheaderlist[i]->viewtime = annotation->onset - mainwindow->edfheaderlist[file_num]->starttime_offset;

      mainwindow->edfheaderlist[i]->viewtime -= (mainwindow->pagetime / 2);
    }
  }

  if(mainwindow->viewtime_sync==VIEWTIME_UNSYNCED)
  {
    mainwindow->edfheaderlist[file_num]->viewtime = annotation->onset - mainwindow->edfheaderlist[file_num]->starttime_offset;

    mainwindow->edfheaderlist[i]->viewtime -= (mainwindow->pagetime / 2);
  }

  if((mainwindow->viewtime_sync==VIEWTIME_SYNCED_ABSOLUT)||(mainwindow->viewtime_sync==VIEWTIME_USER_DEF_SYNCED))
  {
    temp = annotation->onset - mainwindow->edfheaderlist[file_num]->viewtime - mainwindow->edfheaderlist[file_num]->starttime_offset;

    for(i=0; i<mainwindow->files_open; i++)
    {
      mainwindow->edfheaderlist[i]->viewtime += temp;

      mainwindow->edfheaderlist[i]->viewtime -= (mainwindow->pagetime / 2);
    }
  }

  if(mainwindow->annotationEditDock->dockedit->isVisible()==TRUE)
  {
    mainwindow->maincurve->setCrosshair_1_center();
  }

  mainwindow->setup_viewbuf();
}









