dnl aclocal.m4 -- various bits of this have been borrowed from the m4
dnl configuration files for KDE and GNOME

AC_DEFUN(AC_INSTALL_DIRS,
[
AC_MSG_CHECKING(which are the install directories)
dnl set up the defaults

BINDIR="/usr/local/bin"
RCDIR="/etc"
MANDIR="/usr/local/man"
DATADIR="/usr/local/share"

AC_PREFIX_DEFAULT([/usr/local])
if test -n "$prefix" && test "$prefix" != "NONE"; then
  BINDIR="$prefix/bin"
  MANDIR="$prefix/man"
  DATADIR="$prefix/share"
fi

if test -n "$exec_prefix" && test "$exec_prefix" != "NONE"; then
  BINDIR="$exec_prefix/bin"
fi
if test -n "$bindir" && test "$bindir" != "\${exec_prefix}/bin" && test "$bindir" != "NONE"; then
  BINDIR="$bindir"
fi

if test -n "$mandir" && test "$mandir" != "\${prefix}/man" && test "$mandir" != "NONE"; then
  MANDIR="$mandir"
fi

if test -n "$datadir" && test "$datadir" != "\${prefix}/share" && test "$datadir" != "NONE"; then
  DATADIR="$datadir"
fi
if test -n "$sysconfdir" && test "$sysconfdir" != "\${prefix}/etc" && test "$sysconfdir" != "NONE"; then
  RCDIR="$sysconfdir"
fi

SPOOLDIR="/var/spool/fax"
AC_ARG_WITH(spooldir,
  [  --with-spooldir=DIR     Where fax printer filter is installed [default is /var/spool/fax]],
[
if test "$withval" != "no"; dnl 
  then SPOOLDIR="$withval"
fi
])

AC_MSG_RESULT([BINDIR is $BINDIR])
AC_MSG_RESULT([                                              RCDIR is $RCDIR])
AC_MSG_RESULT([                                              SPOOLDIR is $SPOOLDIR])
AC_MSG_RESULT([                                              MANDIR is $MANDIR])
AC_MSG_RESULT([                                              DATADIR is $DATADIR])

AC_SUBST(BINDIR)
AC_SUBST(RCDIR)
AC_SUBST(SPOOLDIR)
AC_SUBST(MANDIR)
AC_SUBST(DATADIR)
])

AC_DEFUN(AC_CHECK_HAVE_IOS_NOCREATE,
[
  AC_MSG_CHECKING(for fstream ios::nocreate flag)
  AC_CACHE_VAL(ac_cv_have_ios_nocreate,
  [
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([
#include <fstream>
    ],
    [
      std::fstream strm("dummy.txt", std::ios::in | std::ios::nocreate);
      strm << 'a';
    ],
    [ac_cv_have_ios_nocreate="yes"],
    [ac_cv_have_ios_nocreate="no"
    ]) dnl end AC_TRY_COMPILE
  ])
  AC_MSG_RESULT([$ac_cv_have_ios_nocreate])
  if test "$ac_cv_have_ios_nocreate" = "yes" ; then
     AC_DEFINE(HAVE_IOS_NOCREATE, 1, [ Define if the C++ fstream object has ios::nocreate ])
  fi 
])

AC_DEFUN(AC_CHECK_GETTEXT,
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
dnl  CFLAGS=""
dnl  LDFLAGS=""
dnl  LIBS=""

  AC_MSG_CHECKING(for gettext)
  AC_CACHE_VAL(ac_cv_have_gettext,
  [
    LIBS="$LIBS $LIBINTL"
    AC_TRY_LINK([
#include <stdlib.h>
#include <libintl.h>
],
[
gettext("Hello");
],
    [ac_cv_have_gettext="yes"],
    [ac_cv_have_gettext="no"])
  ]) dnl end AC_CHECK_VAL
  AC_MSG_RESULT($ac_cv_have_gettext)
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
  if test "$ac_cv_have_gettext" = "yes"; then
    AC_DEFINE(HAVE_GETTEXT, 1, [
inline const char* gettext(const char* text) {return text;}
  ])

  fi
])

AC_DEFUN(AC_CHECK_BOOL,
[
  AC_MSG_CHECKING(for bool)
  AC_CACHE_VAL(ac_cv_have_bool,
  [
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([],
      [bool aBool = true;],
      [ac_cv_have_bool="yes"],
      [ac_cv_have_bool="no"])
  ]) dnl end AC_CHECK_VAL
    AC_MSG_RESULT($ac_cv_have_bool)
    if test "$ac_cv_have_bool" = "yes"; then
      AC_DEFINE(HAVE_BOOL, 1, [
typedef int bool;
const bool false = 0;
const bool true = 1;
    ]) 
    fi 
])

AC_DEFUN(AC_CHECK_COMPILERS,
[
  AC_ARG_ENABLE(debug,[  --enable-debug 	  creates debugging code [default=no]],
  [ 
   if test $enableval = "no"; dnl 
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  dnl Just for configure --help

  dnl this prevents stupid AC_PROG_CXX from adding "-g" to the default CXXFLAGS
  cxx_flags_in=$CXXFLAGS
  AC_PROG_CXX
  CXXFLAGS=$cxx_flags_in

  AC_PROG_CXXCPP

  if test -z "$CXXFLAGS"; then 
    if test "$GXX" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CXXFLAGS="-g $CXXFLAGS"
      else
        CXXFLAGS="-O2 $CXXFLAGS"
        if test -z "$LDLFLAGS"; then 
          LDFLAGS="-s"
        fi
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_COMPILER_FLAG(g,
          [
            CXXFLAGS="-g $CXXFLAGS"
        ])
      else 
        AC_CHECK_COMPILER_FLAG(O2,
          [
            CXXFLAGS="-O2 $CXXFLAGS"
        ])
      fi
    fi
    AC_CHECK_COMPILER_FLAG(fno-exceptions,
      [
        CXXFLAGS="$CXXFLAGS -fno-exceptions"
    ])

    AC_CHECK_COMPILER_FLAG(frtti,
      [
        CXXFLAGS="$CXXFLAGS -frtti"
    ])

    AC_CHECK_COMPILER_FLAG(fsigned-char,
      [
        CXXFLAGS="$CXXFLAGS -fsigned-char"
    ])

    AC_CHECK_COMPILER_FLAG(fno-check-new,
      [
        CXXFLAGS="$CXXFLAGS -fno-check-new"
    ])

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    fi

    AC_CHECK_COMPILER_FLAG(Wno-deprecated,
      [
        CXXFLAGS="$CXXFLAGS -Wno-deprecated"
    ])
  fi  
])

AC_DEFUN(AC_CHECK_COMPILER_FLAG,
[
AC_MSG_CHECKING(whether $CXX supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_cxx_$flag_cache,
[
echo 'int main() { return 0; }' >conftest.cc
eval "ac_cv_prog_cxx_$flag_cache=no"
if test -z "`$CXX -$1 -c conftest.cc 2>&1`"; then
  if test -z "`$CXX -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_cxx_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_cxx_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN(AC_CHECK_MKSTEMP,
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
dnl  CFLAGS=""
dnl  LDFLAGS=""
dnl  LIBS=""
  AC_CHECK_FUNCS(mkstemp,,
    AC_MSG_ERROR([Library function mkstemp is required and cannot be found]))
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
])

AC_DEFUN(AC_CLOSING_MESSAGE,
[
echo
echo "    Configuration complete."
echo
echo "    To compile, enter \`make', and then enter \`make install'"
echo "      -- \`make install' must be run as root."
echo
echo "    To reconfigure, enter \`make clean' and then run \`./configure' again."
echo
])

dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN(PKG_CHECK_MODULES, [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            ## If we have a custom action on failure, don't print errors, but 
            ## do set a variable so people can do so.
            $1_PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$2"`
            ifelse([$4], ,echo $$1_PKG_ERRORS,)
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])
