/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <gdkmm/pixbuf.h>
#include <gtkmm/main.h>
#include <gtkmm/stock.h>

#include "settings_help.h"
#include "window_icon.h"

#ifdef HAVE_GETTEXT
#include <libintl.h>
#endif

Glib::ustring SettingsMessagesBase::get_caption(std::vector<Glib::ustring>::size_type index) {
  if (index > captions.size()) {
    write_error("Yikes, the message index is too large in SettingsMessagesBase::get_caption.\n"
		"Please report the bug to the author.\n");
    return Glib::ustring(); // return empty string
  }
  else return captions[index];
}

Glib::ustring SettingsMessagesBase::get_message(std::vector<Glib::ustring>::size_type index) {
  if (index > messages.size()) {
    write_error("Yikes, the message index is too large in SettingsMessagesBase::get_message.\n"
		"Please report the bug to the author.\n");
    return Glib::ustring(); // return empty string
  }
  else return messages[index];
}

IdentityMessages::IdentityMessages(void): SettingsMessagesBase(number + 1) {

  messages[name] = gettext("Put the name to appear on the fax top header on sent faxes here");
  captions[name] = gettext("efax-gtk help: Name");

  messages[number] = gettext("Put the number to appear on the fax top header on sent faxes here.  "
			     "This will also comprise the fax station ID reported to the sending "
			     "fax machine when receiving faxes");
  captions[number] = gettext("efax-gtk help: Number");
}

ModemMessages::ModemMessages(void): SettingsMessagesBase(rings + 1) {

  messages[device] = gettext("Put the serial device to which the modem is connected "
			     "here (if none is given, the program defaults to "
			     "/dev/modem).  Do not include the `/dev/' part of "
			     "the device name -- ie state it as `ttyS1' or `cua2', etc.  "
			     "With Linux, ttyS0 equates to COM 1, ttyS1 to COM 2, and so on");
  captions[device] = gettext("efax-gtk help: Device");

  messages[lock] = gettext("Put the lock file directory here.  If none is specified, the program "
			   "defaults to /var/lock");
  captions[lock] = gettext("efax-gtk help: Lock File");

  messages[modem_class] = gettext("With efax-0.9 or higher you should usually pick \"Auto\", as then "
				  "efax will work out the class of the modem by itself, but you can "
				  "also force a class by picking one of the specified ones if you "
				  "want.  However, with efax-0.8 the program defaults to Class 2, "
				  "so if you are using a Class 1 modem with old versions of efax "
				  "specify the Class here");
  captions[modem_class] = gettext("efax-gtk help: Modem Class");

  messages[dialmode] = gettext("This specifies whether tone or pulse dialling will be used "
			       "when sending faxes");
  captions[dialmode] = gettext("efax-gtk help: Dial Mode");

  messages[capabilities] = gettext("This specifies the capabilities of the modem.  To see what "
				   "these mean do `man efax', and look at the operation of the "
				   "`-c' flag.  With efax-0.9 and a Class 2 modem, you usually "
				   "won't need to specify this and should leave it blank, as the "
				   "program will interrogate the modem.  If using an older version "
				   "of efax or a different class of modem, values which will work with "
				   "practically any 14,400 bps modem are 1,5,0,2,0,0,0,0, or "
				   "1,3,0,2,0,0,0,0 for slower ones");
  captions[capabilities] = gettext("efax-gtk help: Capabilities");

  messages[rings] = gettext("This defines the number of rings the modem allows to pass before "
			    "answering the telephone when in Standby mode.  Acceptable values "
			    "are 1 to 9.  If none is specified, the program defaults to 1");
  captions[rings] = gettext("efax-gtk help: Rings");
}

ParmsMessages::ParmsMessages(void): SettingsMessagesBase(extra_parms + 1) {

  messages[init] = gettext("This specifies the initialising `AT' commands for the modem when "
			   "in fax mode.  Specify as many of these as are needed, separated by "
			   "spaces for commands which need to be separated, but without a prepended "
			   "`AT'.  If none is specified, the program will default to "
			   "`Z &FE&D2S7=120 &C0 M1L0', which will be correct for practically all "
			   "modems");
  captions[init] = gettext("efax-gtk help: Initialisation Parameters");

  messages[reset] = gettext("This specifies the `AT' commands that will reset the modem.  Specify "
			    "as many commands as are needed, separated by spaces for commands "
			    "which need to be separated, but without a prepended `AT'.  If none is "
			    "specified, the program will default to `Z', which will be correct "
			    "for practically all modems");
  captions[reset] = gettext("efax-gtk help: Reset Parameters");

  messages[extra_parms] = gettext("This can be used to pass any other parameter to efax (do "
				  "`man efax' to see what is available).  Specify as many of these as "
				  "are needed, separated by spaces for different parameters -- eg "
				  "include `-or' to do a bit reversal during receive for Multitech "
				  "modems which require it.  Unless you have an unusual modem, leave "
				  "this blank");
  captions[extra_parms] = gettext("efax-gtk help: Other Parameters");
}

PrintMessages::PrintMessages(void): SettingsMessagesBase(shrink + 1) {

  messages[command] = gettext("This is the command which prints and takes postscript input "
			      "on standard input.  If none is specified, the program will default "
			      "to `lpr'");
  captions[command] = gettext("efax-gtk help: Print Program");

  messages[shrink] = gettext("This will determine the extent to which a printed page will "
			     "be reduced to fit within a printer's print area.  It is a percentage "
			     "-- eg 98 will shrink the page to 98% of its size.  If none is "
			     "specified no shrink will take place (ie, you can, but there is no need "
			     "to, specify 100)");
  captions[shrink] = gettext("efax-gtk help: Print Shrink");
}

ViewMessages::ViewMessages(void): SettingsMessagesBase(ps_view_command + 1) {

  messages[ps_view_command] = gettext("A postscript viewer is used to view sent and received faxes via "
				      "the fax lists, and also to view faxes to be sent identified via "
				      "the \"Files to fax\" file selector dialog.  Specify here the "
				      "command to be used to view postscript files.  If none is specified, "
				      "the program will default to 'gv'.  Other possibilities you may want "
				      "to specify are 'ggv' (the Gnome postscript viewer) or 'kghostview' "
				      "(the KDE postscript viewer). If using gv, you may need to use the "
				      "'-media A4' or '-media Letter' option to select correct paper size.  "
				      "ggv and kghostview do this automatically");
  captions[ps_view_command] = gettext("efax-gtk help: Postscript Viewer Program");
}

LoggingMessages::LoggingMessages(void): SettingsMessagesBase(logfile + 1) {

  messages[logfile] = gettext("This parameter specifies a log file to which progress on negotiations "
			      "and fax status, and errors and warnings, are logged.  If none is specified, "
			      "then no log file will be maintained.  (A log file can also be kept by "
			      "redirecting stdout and stderr -- see the README file for further details)");
  captions[logfile] = gettext("efax-gtk help: Log File");
}

PageMessages::PageMessages(void): SettingsMessagesBase(res + 1) {

  messages[page] = gettext("Specify the page size for faxes here");
  captions[page] = gettext("efax-gtk help: Page Size");

  messages[res] = gettext("This specifies the resolution to which faxes are sent.  \"Standard\" "
			  "gives 204x98 and \"Fine\" gives 204x196");
  captions[res] = gettext("efax-gtk help: Sent Fax Resolution");
}

SettingsHelpDialog::SettingsHelpDialog(const int standard_size, const Glib::ustring& text,
				       const Glib::ustring& caption, Gtk::Window& window):
                                            Gtk::Window(Gtk::WINDOW_TOPLEVEL), in_run_loop(false),
					    close_button(Gtk::Stock::CLOSE),
					    button_box(Gtk::BUTTONBOX_SPREAD),
					    label(text), table(2, 1),
					    parent(window) {


  label.set_line_wrap(true);
  button_box.add(close_button);

  table.attach(label, 0, 1, 0, 1, Gtk::FILL | Gtk::EXPAND,
	 Gtk::FILL | Gtk::EXPAND, standard_size/2, standard_size/4);

  table.attach(button_box, 0, 1, 1, 2, Gtk::FILL | Gtk::EXPAND,
	 Gtk::SHRINK, standard_size/2, standard_size/4);

  add(table);

  close_button.signal_clicked().connect(SigC::slot(*this, &SettingsHelpDialog::kill_dialog));
  close_button.set_flags(Gtk::CAN_DEFAULT);

  set_title(caption);
  set_transient_for(parent);
  set_type_hint(Gdk::WINDOW_TYPE_HINT_DIALOG);
  parent.set_sensitive(false);
  set_modal(true);


  set_border_width(standard_size/4);

  set_position(Gtk::WIN_POS_CENTER);
  set_resizable(false);

  set_icon(Gdk::Pixbuf::create_from_xpm_data(window_icon_xpm));

  show_all();
}

void SettingsHelpDialog::run(void) {
  in_run_loop = true;
  Gtk::Main::run();
}

void SettingsHelpDialog::kill_dialog(void) {
  parent.set_sensitive(true);
  hide_all();
  if (in_run_loop) Gtk::Main::quit();
  // if we have not called run(), then this dialog is self-owning and it is safe to call `delete this'
  else delete this;
}

bool SettingsHelpDialog::on_delete_event(GdkEventAny*) {
  kill_dialog();
  return true; // returning true prevents destroy sig being emitted
}
