/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef MUTEX_H
#define MUTEX_H

#include "prog_defs.h"

#include <pthread.h>

namespace Thread {

class Cond;

class Mutex {
  pthread_mutex_t pthr_mutex;
  
  // mutexes cannot be copied
  Mutex(const Mutex&);
  Mutex& operator=(const Mutex&);
public:
  class Lock;
  friend class Cond;

  int lock(void) {return pthread_mutex_lock(&pthr_mutex);}
  int trylock(void) {return pthread_mutex_trylock(&pthr_mutex);}
  int unlock(void) {return pthread_mutex_unlock(&pthr_mutex);}

  Mutex(void) {pthread_mutex_init(&pthr_mutex, 0);}
  ~Mutex(void) {pthread_mutex_destroy(&pthr_mutex);}
};

class Mutex::Lock {
  Mutex& mutex;

  // locks cannot be copied
  Lock(const Mutex::Lock&);
  Mutex::Lock& operator=(const Mutex::Lock&);
public:

  Lock(Mutex& mutex_): mutex(mutex_) {mutex.lock();}
  ~Lock(void) {mutex.unlock();}
};

class Cond {
  pthread_cond_t cond;

  // Cond cannot be copied
  Cond(const Cond&);
  Cond& operator=(const Cond&);
public:
  int signal(void) {return pthread_cond_signal(&cond);}
  int broadcast(void) {return pthread_cond_broadcast(&cond);}
  int wait(Mutex& mutex) {return pthread_cond_wait(&cond, &mutex.pthr_mutex);}

  Cond(void) {pthread_cond_init(&cond, 0);}
  ~Cond(void) {pthread_cond_destroy(&cond);}
};

} // namespace Thread

#endif
