/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef TREE_ROW_REFERENCE_HANDLE_H
#define TREE_ROW_REFERENCE_HANDLE_H

#include <gtk/gtktreemodel.h>
#include "tree_path_handle.h"
#include "shared_handle.h"

class GtkTreeRowRefFree {
public:
  void operator()(GtkTreeRowReference* obj_p) {
    gtk_tree_row_reference_free(obj_p);
  }
};

typedef SharedHandle<GtkTreeRowReference*, 
		     GtkTreeRowRefFree> TreeRowRefSharedHandle;

// provide operator<() so that a TreeRowRefSharedHandle
// can be a key in an associative container
inline bool operator<(const TreeRowRefSharedHandle& h1, const TreeRowRefSharedHandle& h2) {
  return (gtk_tree_path_compare(TreePathScopedHandle(gtk_tree_row_reference_get_path(h1.get())),
				TreePathScopedHandle(gtk_tree_row_reference_get_path(h2.get())))
	  == -1);
}

#endif
