/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef WIDGET_H
#define WIDGET_H

#include "prog_defs.h"

#include <gtk/gtkwidget.h>

/* Most classes which encapsulate GTK+ objects will implement top
   level widgets derived from GtkWindow (see window.h/window.cpp for a
   WinBase class to manage the lifetime of these).  However, sometimes
   it is convenient for a class to encapsulate only part of the
   implementation of a top level widget, namely in a case where the
   main widget represented by that encapsulation is intended to be
   placed in a GTK+ container object maintained by another class which
   is a child of the top level window..

   The MainWidgetBase class is intended to assist this, by managing
   references with g_object_ref() and gtk_object_sink() such that that
   main widget and its children are correctly destroyed when the
   MainWidgetBase class goes out of scope or is deleted even if they
   are not subsequently placed in another GTK+ container object which
   calls g_object_ref() and gtk_object_sink() on the main widget.

   This class therefore represents a safety feature which can be used
   simply by inheriting from it.

*/

class MainWidgetBase {
  // main widget object
  GtkWidget* g_widget_p;

  // MainWidgetBase cannot be copied
  MainWidgetBase(const MainWidgetBase&);
  MainWidgetBase& operator=(const MainWidgetBase&);
public:
  GtkWidget* get_main_widget(void) const {return g_widget_p;}
  MainWidgetBase(GtkWidget* widget_p);
  virtual ~MainWidgetBase(void);
};

#endif
