-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Contains routines for creating children for containers"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: container.e,v 1.25 2002/08/26 02:42:50 DJAC Exp $"

deferred class CONTAINER

inherit

	WRITER

feature {NONE}

	last_class: CAN_BE_CREATED

	last_class_array: ARRAY[CAN_BE_CREATED]

	name: STRING is
		deferred
		end

	level: INTEGER

	create_child_class_array(tree_array: ARRAY[TAG_TREE]; l: INTEGER) is
		local
			i: INTEGER
		do
			level := l + 1
			create last_class_array.make(0,-1)
			if tree_array /= Void then
				from
					i := 0
				until
					i >= tree_array.count
				loop
					create_child_class(tree_array @ i,l)
					if last_class /= Void then
						last_class_array.add_last(last_class)
					end
					i := i + 1
				end
			end
		ensure
			array_exists: last_class_array /= Void
		end

	create_child_class(tree: TAG_TREE; l: INTEGER) is
		require
			non_void_tree: tree /= Void
		local
			info: CLASS_INFO
			class_writer: CLASS_WRITER
		do
			level := l + 1
			create info.make(tree)
			last_class := Void
			if info.class_name.is_equal("Placeholder") then
				-- TODO: Write a better message!
				print("Warning: Placeholder found%N")
			else
				print("Writing widget '"+info.name+"' of class '")
				print(info.class_name+"'%N")
				if info.class_name.is_equal("GtkDialog") then
					create{GTK_DIALOG_WRITER}last_class.make(tree,info,src_dir)
				elseif info.class_name.is_equal("GtkWindow") then
					create{GTK_WINDOW_WRITER}last_class.make(tree,info,src_dir)
				elseif info.class_name.is_equal("GtkAccelLabel") then
					create{GTK_ACCEL_LABEL_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkAlignment") then
					create{GTK_ALIGNMENT_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkArrow") then
					create{GTK_ARROW_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkAspectFrame") then
					create{GTK_ASPECT_FRAME_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkButton") then
					create{GTK_BUTTON_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCalendar") then
					create{GTK_CALENDAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCheckButton") then
					create{GTK_CHECK_BUTTON_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCheckMenuItem") then
					create{GTK_CHECK_MENU_ITEM_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCList") then
					create{GTK_CLIST_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkColorSelection") then
					create{GTK_COLORSEL_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkColorSelectionDialog") then
					create{GTK_COLOR_SELECTION_DIALOG_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCombo") then
					create{GTK_COMBO_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCTree") then
					create{GTK_CTREE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkCurve") then
					create{GTK_CURVE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkDrawingArea") then
					create{GTK_DRAWING_AREA_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkEntry") then
					create{GTK_ENTRY_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkEventBox") then
					create{GTK_EVENT_BOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkFileSelection") then
					create{GTK_FILE_SELECTION_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkFixed") then
					create{GTK_FIXED_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkFontSelection") then
					create{GTK_FONTSEL_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkFontSelectionDialog") then
					create{GTK_FONT_SELECTION_DIALOG_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkFrame") then
					create{GTK_FRAME_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkGammaCurve") then
					create{GTK_GAMMA_CURVE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHandleBox") then
					create{GTK_HANDLE_BOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHBox") then
					create{GTK_HBOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHButtonBox") then
					create{GTK_HBUTTON_BOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHPaned") then
					create{GTK_HPANED_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHRuler") then
					create{GTK_HRULER_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHScale") then
					create{GTK_HSCALE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHScrollbar") then
					create{GTK_HSCROLLBAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkHSeparator") then
					create{GTK_HSEPARATOR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkInputDialog") then
					create{GTK_INPUT_DIALOG_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkLabel") then
					create{GTK_LABEL_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkLayout") then
					create{GTK_LAYOUT_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkList") then
					create{GTK_LIST_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkMenuBar") then
					create{GTK_MENU_BAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkMenuItem") then
					debug
						print("CONTAINER: generating menu item in (" + generating_type + ") " + name +"%N")
					end
					if generating_type.is_equal("GTK_POPUP_MENU_WRITER") then
						create{GTK_MENU_ITEM_WRITER}last_class.make_in_popup(info.name,tree,src_dir)
					else
						create{GTK_MENU_ITEM_WRITER}last_class.make(info.name,tree,src_dir)
					end
				elseif info.class_name.is_equal("GtkMenu") then
					if level <= 1 then
						create{GTK_POPUP_MENU_WRITER}last_class.make(tree,info,src_dir)
					else
						create{GTK_MENU_WRITER}last_class.make(info.name,tree,src_dir)
					end
				elseif info.class_name.is_equal("GtkNotebook") then
					create {GTK_NOTEBOOK_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkOptionMenu") then	
					create{GTK_OPTION_MENU_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkPacker") then
					create{GTK_PACKER_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkPixmap") then
					create{GTK_PIXMAP_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkPreview") then	
					create{GTK_PREVIEW_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkProgressBar") then
					create{GTK_PROGRESS_BAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkRadioButton") then
					create{GTK_RADIO_BUTTON_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkRadioMenuItem") then	
					create{GTK_RADIO_MENU_ITEM_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkScrolledWindow") then
					create{GTK_SCROLLED_WINDOW_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkSpinButton") then	
					create{GTK_SPIN_BUTTON_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkStatusbar") then
					create{GTK_STATUS_BAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkTable") then
					create{GTK_TABLE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkText") then
					create{GTK_TEXT_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkToggleButton") then
					create{GTK_TOGGLE_BUTTON_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkToolbar") then
					create{GTK_TOOLBAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkTree") then
					create{GTK_TREE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVBox") then
					create{GTK_VBOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVButtonBox") then
					create{GTK_VBUTTON_BOX_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkViewport") then
					create{GTK_VIEWPORT_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVPaned") then
					create{GTK_VPANED_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVRuler") then
					create{GTK_VRULER_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVScale") then
					create{GTK_VSCALE_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVScrollbar") then
					create{GTK_VSCROLLBAR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GtkVSeparator") then
					create{GTK_VSEPARATOR_WRITER}last_class.make(info.name,tree,src_dir)
				elseif info.class_name.is_equal("GnomeCanvas") then
					create{GNOME_CANVAS_WRITER}last_class.make(info.name,tree,src_dir)
				end
				-- last_class = Void if there is no writer for the widget
				if last_class = Void then
					print("Class "+info.class_name+" is unrecognized. Ignoring.%N")
				else
					-- If the writer is a class_writer then write the class file
					class_writer ?= last_class
					if class_writer /= Void then
						class_writer.write_class
					end
				end
			end
		end

end -- CONTAINER
