-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class writes the CUSTOMISATION class"
	author:		"Oliver Elphick <olly@lfix.co.uk>"
	date:          "October 31 1999"
	cvs:           "$Id: custom_class_writer.e,v 1.7 2003/01/01 21:34:19 elphick Exp $"

class CUSTOM_CLASS_WRITER

inherit

   PRESERVED_CLASS_WRITER
      rename
			widget_tree as interface
      redefine
			write_creation
      end

creation
	make

feature
	
	name: STRING is "GTK-Interface"
	root_features: LINKED_LIST[CAN_BE_CREATED]

	inherit_from: STRING is "VERSION"

	make(src: STRING) is
			-- Writes the source file
		require
			valid_src: src /= Void and then not src.is_empty
		do
			src_dir := src
			generate_name("CUSTOMISATION", False)
			gen_inherit
		end

	write_features is
		do
		   write_line ("begin is")
		   indent
		   write_line("do")
		   write_line("end")
		   outdent
			blank_line
			write_line("set_rc_file is")
			indent
			write_line("do")
			indent
			write_line("-- Uncomment and edit the next line if there is a global rc file")
			write_line("-- rc_file := %"/path/to/rc/file%"")
			outdent
			write_line("end")
			outdent
			blank_line
		   write_line ("rc_file: STRING is")
			indent
			write_line("deferred")
			write_line("end")
			outdent
			blank_line
		end

	write_make_body is
		do
		end

	write_creation is
		do
		end

end -- CUSTOM_CLASS_WRITER
