-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Common class for signal writing"
	author: "Oliver Elphick <olly@lfix.co.uk>"
	cvs: "$Id: signal_common.e,v 1.6 2002/08/26 02:43:18 DJAC Exp $"

class SIGNAL_COMMON

feature

	signals: ARRAY[SIGNAL_WRITER]

	append_signal_declarations(code: ARRAY[STRING]) is
		local
			i: INTEGER
		do
			if signals /= Void then
				from
					i := signals.lower
				until
					i > signals.upper
				loop
					(signals @ i).append_parent_declaration(code)
					i := i + 1
				end
			end
		end

feature {NONE}

	make_signals(signal_trees: ARRAY[TAG_TREE]) is
		local
			i: INTEGER
			sig: SIGNAL_WRITER
		do
			if signal_trees /= Void then
				create signals.make(signal_trees.lower, signal_trees.upper)
				from
					i := signal_trees.lower
				until
					i > signal_trees.upper
				loop
					create sig.make(signal_trees @ i, src_dir)
					sig.write_class
					signals.put(sig, i)
					i := i + 1
				end
			end
		end

	append_signal_code(strings: ARRAY[STRING]; object_name: STRING) is
		require
			objname_set: object_name /= Void and then not object_name.is_empty
		local
			i: INTEGER
		do
			if signals /= Void then
				from
					i := signals.lower
				until
					i > signals.upper
				loop
					(signals @ i).append_parent_creation(strings)
					strings.add_last(object_name+".add_action(%""+(signals @ i).name+"%", "+(signals @ i).handler_instance+")")
					i := i + 1
				end
			end
		end

end -- SIGNAL_COMMON
