-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkMenu objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_menu_writer.e,v 1.10 2002/08/26 02:32:48 DJAC Exp $"

class GTK_MENU_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end
	
creation

	make

feature

		
	type: STRING is "GTK_MENU"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			create_child_class_array(widget_tree.find_children("widget"), 1)
		end
			
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("create " + name + ".make")
			add_widget_code(code)
			precursor(code)
		end

feature {NONE}

    append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		do
			code.add_last(name + ".append(" + widget.name + ")")
        end

end
