-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkOptionMenu objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_option_menu_writer.e,v 1.8 2002/08/26 02:32:48 DJAC Exp $"

class GTK_OPTION_MENU_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end
	
	CHILD

creation

	make

feature

		
	type: STRING is "GTK_OPTION_MENU"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			initial := widget_tree.get_integer_string_from_field("initial_choice")
			items := widget_tree.get_string_from_field("items")
		end
			
	initial: STRING
	items: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		local
			i, j: INTEGER
			strings: STRING
		do
			if not items.is_empty then
				create strings.make(0)
				from
					i := 0
				until
					items.is_empty
				loop
					j := items.substring_index("%%N", 1)
					if j > 1 then
						strings.append("%""+items.substring(1, j - 1)+"%"")
						items.remove_first(j + 1)
					elseif j = 1 then
						strings.append("%"%"")
						items.remove_first(2)
					else
						strings.append(items)
						items.remove_last(items.count)
					end
					if not items.is_empty then
						strings.append(", ")
					end
					i := i + 1
				end
			end
			code.add_last("create " + name + ".make")
			if i > 0 then
				code.add_last(name + ".set_menu_strings(<<" + strings + ">>)")
			end
			code.add_last(name + ".set_history(" + initial + ")")
			add_widget_code(code)

		end

end
