-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkMenuBar objects"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_radio_menu_item_writer.e,v 1.6 2002/08/26 02:33:20 DJAC Exp $"

class GTK_RADIO_MENU_ITEM_WRITER

inherit

	GTK_MENU_ITEM_WRITER
		redefine
			make, append_parent_creation, type
		end
	
creation

	make

feature

		
	type: STRING is "GTK_RADIO_MENU_ITEM"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			radio_writer_list: ARRAY[GTK_RADIO_MENU_ITEM_WRITER]
		do
			precursor(attr_name, tree, src)
			-- the precursor will create a list of sub widgets which is pretty
			-- pointless as noone would want a submenu to come out of a radio
			-- item, but glade will let you do it.
			active := widget_tree.get_boolean_string_from_field("active")
			always_show_toggle :=
				widget_tree.get_boolean_string_from_field("always_show_toggle")
			group := widget_tree.get_string_from_field("group")
			if groups_list.has(group) then
				radio_writer_list := groups_list.at(group)
				radio_writer_list.add_last(Current)
			else
				create radio_writer_list.make(0,0)
				radio_writer_list.put(Current, 0)
			end
			groups_list.put(radio_writer_list, group)
		end

	active: STRING
	always_show_toggle: STRING
	group: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			if groups_list.at(group) @ 0 = Current then
				code.add_last("create " + name + ".make_with_label(%""+label+"%")")
			else
				code.add_last("create " + name + ".make_with_group_and_label("+(groups_list.at(group) @ 0).name + ".group, %"" + label + "%")")
			end
			add_common_menu_item_code(code)
			code.add_last(name + ".set_active("+ active + ")")
			code.add_last(name + ".set_show_toggle(" +always_show_toggle+ ")")
		end

	groups_list: DICTIONARY[ARRAY[GTK_RADIO_MENU_ITEM_WRITER], STRING] is
		once
			create Result.make
		end

end
