-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

   description: "Writes source files for GtkWindow objects"
   author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
   cvs: "$id$"

class GTK_WINDOW_WRITER

inherit

   GTK_WINDOW_WRITER_COMMON

creation

   make

feature
	
   child_widget: CAN_BE_CREATED

   inherit_from: STRING is "GTK_WINDOW"

   make(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
      do
	 make_common(tree, info, src)
	 create_child_class(widget_tree.find_child("widget"), 1)
	 child_widget := last_class
	 if child_widget /= Void then
	    inherit_list.merge_with(last_class.parent_inherit)
	 end

	 visible := tree.get_boolean_from_field("visible", True)
      end
			
   append_parent_creation(code: ARRAY[STRING]) is
      do
	 code.add_last("create " + name + ".make")
	 append_top_level_show(code)
      end

   write_features is
      local
	 code: ARRAY[STRING]
      do
	 if child_widget /= Void then
	    create code.make(0,-1)
	    child_widget.append_parent_declaration(code)
	    write_lines(code)
	 end
      end

   write_make_body is
      local
	 code: ARRAY[STRING]
      do
	 create code.make(0,-1)
	 append_signal_declarations(code)
	 write_lines(code)
	 write_line("make is")
	 indent
	 write_line("local")
	 write_line("do")
	 indent
	 if is_vegtk then
	    write_line("make_gtk_window(Gtk_window_toplevel)")
	 else
	    write_line("make_top_level")
	 end
	 write_make_body_common(code)
	 if child_widget /= Void then
	    code.clear
	    child_widget.append_parent_creation(code)
	    write_lines(code)
	    if is_vegtk then
	       write_line("add("+child_widget.name+")")
	    else
	       write_line("add_widget("+child_widget.name+")")
	    end
	 end
	 outdent
	 write_line("end")
	 outdent
      end
   
end -- GTK_WINDOW_WRITER
