%%%----------------------------------------------------------------------
%%% File    : mod_shared_roster_ldap.hrl
%%% Author  : Marcin Owsiany <marcin@owsiany.pl>
%%% Purpose : A record to keep mod_shared_roster_ldap state data.
%%% Created : 7 Feb 2010 by Marcin Owsiany <marcin@owsiany.pl>
%%% Version : 0.5.3
%%%----------------------------------------------------------------------

%%%----------------------------------------------------------------------
%%% Contribution page: http://www.ejabberd.im/mod_shared_roster_ldap
%%% Project page:  https://alioth.debian.org/projects/ejabberd-msrl/
%%% Documentation: https://alioth.debian.org/docman/?group_id=100433
%%%----------------------------------------------------------------------

% Remember to update mod_shared_roster_ldap:assert_states_equal/2 when changing
% this.
-record(state, {
	  host,
	  eldap_id,
	  servers,
	  port,
	  tls_options,
	  dn,
	  base,
	  password,
	  uid,
	  group_attr,
	  group_desc,
	  user_desc,
	  user_uid,
	  uid_format,
	  uid_format_re,
	  filter,
	  ufilter,
	  rfilter,
	  gfilter,
	  auth_check,
	  cached_users,
	  cached_users_timestamp,
	  user_cache_validity = 5*60,
	  cached_groups,
	  cached_groups_timestamp,
	  group_cache_validity = 5*60
	 }).


-record(group_info, {desc, members}).

