/*
 
    Ejecter - Safely, easily remove external peripherals
    Copyright 2008-2009, Federico Pelloni <federico.pelloni@gmail.com>
 
    
    This file is part of Ejecter.
 
    Ejecter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Ejecter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Ejecter.  If not, see <http://www.gnu.org/licenses/>.
   
*/ 

using GLib, Gtk;


namespace Ejecter {

namespace Alternatives {


    // This builds the icon for a device from the GDrive GIcon (since Gtk 2.14)
    public Gtk.Image build_device_icon (GLib.Drive drive) {

        return new Gtk.Image.from_gicon(drive.get_icon(), Gtk.IconSize.BUTTON);
        
    }
    
    
    // Since Gtk 2.14 we can use builtin hooks
    public void set_url_hooks (Ejecter.About about) {
    
        Gtk.AboutDialogActivateLinkFunc show_url = (dialog, link) => { 
                                       Gtk.show_uri(Gdk.Screen.get_default(), link, Gdk.CURRENT_TIME); };
        about.set_url_hook(show_url);
        about.set_email_hook(show_url);
    
    }

    
}

}
