/* daemon/fds.h
 *
 * Interface to poll and fd handling
 *
 * Copyright 2009 Simtec Electronics
 *
 * For licence terms refer to the COPYING file.
 */

#ifndef DAEMON_FDS_H
#define DAEMON_FDS_H

typedef void (* ekeyfd_pollfunc_t)(int fd, short events, void *pw); 

int ekeyfd_add(int fd, short events, ekeyfd_pollfunc_t func, void *pw);

int ekeyfd_poll(int timeout);

int ekeyfd_rm(int fd);

void ekeyfd_set_events(int fd, short events);

void ekeyfd_clear_events(int fd, short events);

#endif
