/*
 *   utils.h
 *   Copyright (C) 2019 David García Goñi <dagargo@gmail.com>
 *
 *   This file is part of Elektroid.
 *
 *   Elektroid is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Elektroid is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Elektroid. If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#define LABEL_MAX 128

#define ELEKTROID_FILE 'F'
#define ELEKTROID_DIR 'D'

#define debug_print(level, ...) if (level <= debug_level) fprintf(stderr, __VA_ARGS__)

int debug_level;

void print_ascii_msg (const GByteArray *);

void debug_print_hex_msg (const GByteArray *);

char *chain_path (const char *, const char *);

void remove_ext (char *);

const char *get_ext (const char *);

char get_type_from_inventory_icon (const char *);

const char *get_inventory_icon_from_type (char);

char *get_local_startup_path (const char *);
