/* $Id: IntfAttrib.c,v 1.7 1999/08/06 09:27:30 cogito Exp peter $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "IntfAttrib.h"
#include "envmod.h"
#include "err.h"
#include "csm.h"
#include "List.h"
#include "Syntax.h"
#include "Consts.h"
#include "AttrDefs.h"
#include "GlobDef.h"
#include "VoidChk.h"
#include "LigaDid.h"
#include "pdl_gen.h"
#include "Names.h"

#include "LIGA.h"
#include "LIGAMacros.h"
#include "lookup_idl.h"
#include "liga_func.h"
#include "ligaconsts.h"
#include "msgtxt.h"
/* access to csm module */
#define GetStringRef(s) (strng[s])

static POSITION NullPos = {0, 0};
static bool oldtermstyle = false;

static SEQDef oldtermprods = nullSEQDef();
static SEQAttribution oldtermattrib = nullSEQAttribution();

void
OldTermRules(env, attrenv)
   Environment env, attrenv;
{
   DefTableKey symkey;
   Scope scdefs;

   /* search old style TERMs and add rules: */
   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      symkey = KeyOf(scdefs);
      if (SymDef == GetDefKind(symkey, TypeDef) &&
	  GetRealSym(symkey, false))
      {
	 int symid;

	 symid = IdnOf(scdefs);
	 if (GetOldTerm(symkey, 0))
	 {
	    /* old terminal use: */
	    POSITION *coordref;
	    SEQEntity rhs;
	    Entity ent;
	    int symdid, ruledid;
	    Environment symenv;
	    Scope attrs;
	    DefTableKey atkey, attrnamekey, defkey;
	    int atid, atdid, attp, atcl;
	    char *attpname;
	    Scope alldefs;
	    Def ruledef;
	    Attribution atrules;

	    symdid = GetDid(symkey, DIDNON);
	    coordref = GetCoord(symkey, &NullPos);

	    /* find type of intrinsic attr: */
	    attp = DIDNON;
	    symenv = GetAttrScope(symkey, NoEnv);
	    attrs = DefinitionsOf(symenv);
	    while (attrs != NoScope)
	    {
	       atkey = KeyOf(attrs);
	       atid = IdnOf(attrs);
	       attrs = NextDefinition(attrs);

	       atcl = GetAttrClass(atkey, ATCLUNKN);
	       if (atcl == ATCLINH)
		  continue;

	       if (atcl == ATCLUNKN)
	       {
		  /* take class from ATTR name def: */
		  attrnamekey = KeyInEnv(attrenv, atid);
		  atcl = GetAttrClass(attrnamekey, ATCLUNKN);
	       }
	       if (atcl == ATCLINH)
		  continue;
	       /* attr of class SYNT or UNKN found: */
	       atdid = GetDid(atkey, DIDNON);

	       attp = GetAttrType(atkey, DIDNON);
	       if (attp != DIDNON)
		  break;

	       /* take type from ATTR name def: */
	       attrnamekey = KeyInEnv(attrenv, atid);

	       attp = GetAttrType(attrnamekey, DIDNON);

	       /* type found, may be DIDNON */
	       break;
	    }

	    /* find terminal type name: */
	    if (attp == DIDNON)	/* default int: */
	       attpname = "int";
	    else
	    {
	       alldefs = DefinitionsOf(env);
	       while (alldefs != NoScope)
	       {
		  defkey = KeyOf(alldefs);
		  if (attp == GetDid(defkey, DIDNON))
		  {
		     attpname = GetStringRef(IdnOf(alldefs));
		     break;
		  }
		  alldefs = NextDefinition(alldefs);
	       }
	    }

	    /* generate new RULE: */
	    /* rhs of production ::= '' 'symbolname' 'typename' constructed
	     * backwards: */
	    rhs = nullSEQEntity();

	    /* type id: */
	    ent = UnitToEntity(MkUnit(
				      coordref->line, coordref->col,
				      LiteralToUnit(MkLiteral(attpname))));
	    rhs = AppFrontSEQEntity(ent, rhs);

	    /* terminal id: */
	    ent = UnitToEntity(MkUnit(
				      coordref->line, coordref->col,
			    LiteralToUnit(MkLiteral(GetStringRef(symid)))));
	    rhs = AppFrontSEQEntity(ent, rhs);

	    /* marker: */
	    ent = UnitToEntity(MkUnit(
				      coordref->line, coordref->col,
				      LiteralToUnit(MkLiteral(NoString))));
	    rhs = AppFrontSEQEntity(ent, rhs);

	    ruledid = GenDid();
	    ruledef = MkDef(ruledid, CatStrings("_RNT_", GetStringRef(symid)),
			    coordref->line, coordref->col,
			    ProdToDef(MkProd(symdid, rhs)));

	    oldtermprods = AppFrontSEQDef(ruledef, oldtermprods);

	    /* generate attribution for that RULE: */
	    if (attp == DIDNON)	/* no computation: */
	       atrules = MkAttribution(ruledid, nullSEQAttrrule());
	    else
	    {
	       SEQExpr termacc = creatSEQExpr
	       (CallToExpr
		(
		 MkCall
		 (TERMFCT,
		  creatSEQExpr
		  (ValToExpr
		   (MkVal
		    (1,
		     coordref->line,
		     coordref->col
		     )
		    )
		   ),
		  coordref->line,
		  coordref->col
		  )
		 ));

	       Call ca2 =
	       MkCall
	       (ASSIGNFCT,
		AppFrontSEQExpr
		(AttraccToExpr
		 (MkAttracc
		  (0, atdid,
		   coordref->line, coordref->col
		   )
		  ),
		 termacc
		 ),
		coordref->line,
		coordref->col
	       );

	       atrules = MkAttribution
		  (ruledid,
		   creatSEQAttrrule
		   (CallToAttrrule
		    (ca2
		     )
		    )
		  );
	    }

	    oldtermattrib = AppFrontSEQAttribution(atrules, oldtermattrib);
	 }	/* end IsOldTerm */
      }	/* end symbol def */
      scdefs = NextDefinition(scdefs);
   }	/* end while definitions */
}

int
ContainsNonAsciiChars(str)
   char* str;
{ /* check whether str contains chars with value > 127.
     such 8-bit values are not supported by the idl textual
     interface format between the liga passes.
  */
  char *p = str;
  while (*p)
  { if (*p & 0x80)
    return 1;
    p++;
  }
  return 0;
}

Expr
MakeLit(kind, str, line, col)
   char *str, *kind;
   int line, col;
{
   Expr ex;
   Literal lit;
   Call c;



   lit = MkLiteral(str);
   ex = LiteralToExpr(lit);
   c = MkCall(kind, creatSEQExpr(ex), line, col);
   ex = CallToExpr(c);
   return (ex);
}/* MakeLit */

int
CompAttrdef(ad1, ad2)
   Attrdef ad1, ad2;
{
   return (strcmp(nameOfAttrdef(ad1), nameOfAttrdef(ad2)) >= 0);
}/* CompAttrdef */

static Environment attrnameenv;

SEQAttrdef
MakeAttrDefs(env, isterm)
   Environment env;
   int isterm;
{
   Scope scdefs;
   SEQAttrdef res;
   Attrdef d;
   DefTableKey k, attrnamekey;
   POSITION *coordref, *namepos;
   int prodid, id, attrdid, atcl, attp;
   int intrinsics = 0;

   res = nullSEQAttrdef();

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      coordref = GetCoord(k, &NullPos);
      id = IdnOf(scdefs);
      prodid = GetAttrProdDid(k, DIDNON);

      attp = GetAttrType(k, DIDNON);
      if (attp == DIDNON)
      {
	 /* take type from ATTR name def: */
	 attrnamekey = KeyInEnv(attrnameenv, id);
	 if (attrnamekey == NoKey)
	    attp = DIDVOID;
	 else
	 {
	    attp = GetAttrType(attrnamekey, DIDVOID);
	    namepos = GetCoord(attrnamekey, &NullPos);
	    UpdateType(k, attp, namepos);
	 }
      }
      atcl = GetAttrClass(k, ATCLUNKN);
      if (atcl == ATCLUNKN)
      {
	 /* take class from ATTR name def: */
	 attrnamekey = KeyInEnv(attrnameenv, id);
	 if (attrnamekey == NoKey)
	    atcl = ATCLUNKN;
	 else
	 {
	    atcl = GetAttrClass(attrnamekey, ATCLUNKN);
	    namepos = GetCoord(attrnamekey, &NullPos);

	    if (isterm && atcl == ATCLUNKN)
	       atcl = ATCLSYNT;	/* old term style */
	    UpdateClass(k, atcl, namepos);
	 }
      }
      attrdid = GetDid(k, DIDNON);
      SetVoidDid(attrdid, (attp == DIDVOID || attp == DIDVOLI));


      d = MkAttrdef(
		    attrdid,
		    GetStringRef(id),
		    coordref->line, coordref->col,
		    attp,
		    atcl,
		    prodid,
		    STORUNKN, GENORIG, 0, NoString);
      res = AppFrontSEQAttrdef(d, res);

      /* check for old term style only: */
      if (isterm)
      {
	 if (atcl == ATCLSYNT)
	 {
	    intrinsics++;
	    if (intrinsics > 1)
	       message(ERROR,
		       MSGTXT("More than one intrinsic attribute",
			      (lidoref) Outdated Constructs),
		       0, coordref);
	 }
      }
      scdefs = NextDefinition(scdefs);
   }
   return (res);
}/* MakeAttrDefs */

SEQEntity
MakeProdRhs(symblist, nextisgen)
   TList symblist;
   bool nextisgen;
{
   ProdElem symb;
   Entity ent;
   SEQEntity res;

   if (symblist == NullList)
      return (nullSEQEntity());

   symb = (ProdElem) HeadList(symblist);
   if (symb->IsSymbol)
   {
      res = MakeProdRhs(TailList(symblist), false);
      if (GetSymClass(symb->Key, SYMBNONT) == SYMBNONT ||
	  GetOldTerm(symb->Key, 0))
      {
	 ent = UnitToEntity(MkUnit(
				   symb->Coord->line, symb->Coord->col,
				   SymbolToUnit(MkSymbol(symb->Id))));
	 return (AppFrontSEQEntity(ent, res));
      } else
      {	/* terminal occurrence encoded by '' 'symbolname' 'typename'
	 * constructed backwards: */
	 DefTableKey attrtypekey;

	 /* type id: */
	 attrtypekey = GetTermType(symb->Key, NoKey);
	 if (attrtypekey == NoKey)	/* default TNINT: */
	    ent = UnitToEntity(MkUnit(
				      symb->Coord->line, symb->Coord->col,
				      LiteralToUnit(MkLiteral(TNINT))));
	 else
	    ent = UnitToEntity(MkUnit(
				      symb->Coord->line, symb->Coord->col,
				      LiteralToUnit(MkLiteral(
				      GetStringRef(GetIdent(attrtypekey, 0))
							      ))));
	 res = AppFrontSEQEntity(ent, res);

	 /* terminal id: */
	 ent = UnitToEntity(MkUnit(
				   symb->Coord->line, symb->Coord->col,
				   LiteralToUnit(
						 MkLiteral(
							   GetStringRef(
						GetIdent(symb->Key, 0))))));
	 res = AppFrontSEQEntity(ent, res);

	 /* marker: */
	 ent = UnitToEntity(MkUnit(
				   symb->Coord->line, symb->Coord->col,
				   LiteralToUnit(MkLiteral(NoString))));
	 res = AppFrontSEQEntity(ent, res);
      }
   } else
   {
      nextisgen = symb->Id == SyntGenMark;
      res = MakeProdRhs(TailList(symblist), nextisgen);
      ent = UnitToEntity(MkUnit(
				symb->Coord->line, symb->Coord->col,
				LiteralToUnit(MkLiteral(
			(nextisgen ? NoString : GetStringRef(symb->Id))))));
      res = AppFrontSEQEntity(ent, res);
   }
   return res;
}/* MakeProdRhs */


Prod
MakeProd(symblist)
   TList symblist;
{
   ProdElem symb;
   int lhsdid;
   SEQEntity rhs;

   symb = (ProdElem) HeadList(symblist);
   lhsdid = symb->Id;
   rhs = MakeProdRhs(TailList(symblist), false);
   return (MkProd(lhsdid, rhs));
}/* MakeProd */

SEQDef
MakeAllDefs(env, attrenv)
   Environment env, attrenv;
{
   Scope scdefs;
   SEQDef res;
   Def d;
   DefTableKey k;
   POSITION *coordref;
   int did, id, tp;

   OldTermRules(env, attrenv);

   InitMapDidToIsVoid(GenDid());
   attrnameenv = attrenv;

   res = nullSEQDef();

   /* chains: */

   scdefs = DefinitionsOf(attrenv);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      if (isChainAttr == GetAttrKind(k, isAttrName))
      {
	 did = GetDid(k, DIDNON);
	 coordref = GetCoord(k, &NullPos);

	 tp = GetAttrType(k, DIDVOID);
	 SetVoidDid(did, (tp == DIDVOID || tp == DIDVOLI));

	 d = MkDef(did, GetStringRef(IdnOf(scdefs)),
		   coordref->line, coordref->col,
		   ChainToDef(MkChain(tp)));
	 res = AppFrontSEQDef(d, res);
      }
      scdefs = NextDefinition(scdefs);
   }

   /* productions: */

   /* generated term prods: */
   while (oldtermprods != nullSEQDef())
   {
      retrievefirstSEQDef(oldtermprods, d);
      res = AppFrontSEQDef(d, res);
      oldtermprods = tailSEQDef(oldtermprods);
   }

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      if (RuleDef == GetDefKind(k, TypeDef))
      {
	 did = GetDid(k, DIDNON);
	 coordref = GetCoord(k, &NullPos);
	 id = IdnOf(scdefs);
	 d = MkDef(did, GetStringRef(id),
		   coordref->line, coordref->col,
		   ProdToDef(MakeProd(
				      GetRuleProd(k, NullList))));
	 res = AppFrontSEQDef(d, res);
      }
      scdefs = NextDefinition(scdefs);
   }

   /* symbols: */

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      if (SymDef == GetDefKind(k, TypeDef) &&
	  GetRealSym(k, false))
      {
	 id = IdnOf(scdefs);
	 did = GetDid(k, DIDNON);
	 coordref = GetCoord(k, &NullPos);
	 if (GetOldTerm(k, 0))
	 {
	    /* old terminal use, transform: */
	    oldtermstyle = true;
	    message(WARNING, MSGTXT("Old style TERM transformed",
				    (lidoref) Outdated Constructs),
		    0, coordref);
	    d = MkDef(did, CatStrings("NT_", GetStringRef(id)),
		      coordref->line, coordref->col,
		      SymbToDef(MkSymb(
				       SYMBNONT,
				       MakeAttrDefs(
						    GetAttrScope(k, NoEnv),
						    true))));
	    res = AppFrontSEQDef(d, res);
	 } else if (GetSymClass(k, SYMBTERM) == SYMBNONT)
	 {
	    d = MkDef(did, GetStringRef(id),
		      coordref->line, coordref->col,
		      SymbToDef(MkSymb(
				       SYMBNONT,
				       MakeAttrDefs(
						    GetAttrScope(k, NoEnv),
						    false))));
	    res = AppFrontSEQDef(d, res);
	 }
      }
      scdefs = NextDefinition(scdefs);
   }

   /* terminals indicated by Typedefs: extname component is marked TERMFCT or
    * OLDTERMFCT */

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      if (SymDef == GetDefKind(k, TypeDef) &&
	  SYMBTERM == GetSymClass(k, SYMBNONT))
      {
	 did = GetDid(k, DIDNON);
	 coordref = GetCoord(k, &NullPos);
	 d = MkDef(did, GetStringRef(IdnOf(scdefs)),
		   coordref->line, coordref->col,
		   TypedefToDef(MkTypedef(
				  (GetOldTerm(k, 0) ? OLDTERMFCT : TERMFCT),
					  DIDNON)));
	 res = AppFrontSEQDef(d, res);
      }
      scdefs = NextDefinition(scdefs);
   }

   /* types: */

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      k = KeyOf(scdefs);
      if (TypeDef == GetDefKind(k, SymDef))
      {
	 did = GetDid(k, DIDNON);
	 if (did > DIDNODE)
	 {
	    coordref = GetCoord(k, &NullPos);
	    d = MkDef(did, GetStringRef(IdnOf(scdefs)),
		      coordref->line, coordref->col,
		      TypedefToDef(MkTypedef(
					     NoString, DIDNON)));
	    res = AppFrontSEQDef(d, res);
	 }
      }
      scdefs = NextDefinition(scdefs);
   }

   d = MkDef(DIDNODE, TNNODE, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDCOORD, TNCOORD, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDSYMB, TNSYMB, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDBOOL, TNBOOL, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDINT, TNINT, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDVOLI, TNVOLI, 1, 1,
	     TypedefToDef(MkTypedef("", 0)));
   res = AppFrontSEQDef(d, res);
   d = MkDef(DIDVOID, TNVOID, 1, 1,
	     TypedefToDef(MkTypedef("", DIDVOLI)));
   res = AppFrontSEQDef(d, res);

   return (res);
}/* MakeAllDefs */


void
UpdateAttrib(rskey, cmp, islow)
   DefTableKey rskey;
   Attrrule cmp;
   int islow;
{
   SEQAttrrule seq;

   if (RuleDef == GetDefKind(rskey, RuleDef))
   {
      seq = GetAttrib(rskey, nullSEQAttrrule());
      seq = AppFrontSEQAttrrule(cmp, seq);
      SetAttrib(rskey, seq, seq);
   } else if (islow)
   {
      seq = GetLowAttrib(rskey, nullSEQAttrrule());
      seq = AppFrontSEQAttrrule(cmp, seq);
      SetLowAttrib(rskey, seq, seq);
   } else
   {
      seq = GetUpAttrib(rskey, nullSEQAttrrule());
      seq = AppFrontSEQAttrrule(cmp, seq);
      SetUpAttrib(rskey, seq, seq);
   }
}/* UpdateAttrib */

SEQAttribution
MakeAttributions(env)
   Environment env;
{
   Scope scdefs;
   DefTableKey rkey;
   SEQAttribution seq;
   Attribution at;
   int did;

   seq = nullSEQAttribution();

   /* generated term attributions: */
   while (oldtermattrib != nullSEQAttribution())
   {
      retrievefirstSEQAttribution(oldtermattrib, at);
      seq = AppFrontSEQAttribution(at, seq);
      oldtermattrib = tailSEQAttribution(oldtermattrib);
   }

   scdefs = DefinitionsOf(env);
   while (scdefs != NoScope)
   {
      rkey = KeyOf (scdefs);
      if (RuleDef == GetDefKind (rkey, TypeDef))
      {
	 did = GetDid (rkey, DIDNON);
         PostProcComps (rkey);
	 at = MkAttribution (did, GetAttrib (rkey, nullSEQAttrrule()));
	 seq = AppFrontSEQAttribution (at, seq);
      }
      scdefs = NextDefinition (scdefs);
   }
   return (seq);
}/* MakeAttributions */

int
HasGenAttrComp(syntpos, symkey, prodkey)
   int syntpos;
   DefTableKey symkey, prodkey;
{
   SEQAttrrule comps;
   Attrrule comp;
   Expr ex;
   Attracc attr;
   int atdid;
   Environment env;

   env = GetAttrScope(symkey, NoEnv);
   if (env == NoEnv)
      return 0;

   atdid = GetDid(KeyInEnv(env, GenAttrId), DIDNON);
   if (atdid == DIDNON)
      return 0;

   foreachinSEQAttrrule(GetAttrib(prodkey, nullSEQAttrrule()), comps, comp)
      if (typeof(comp) == KCall &&
	  (strcmp(ASSIGNFCT, nameOfCall(AttrruleToCall(comp))) == 0))
   {
      retrievefirstSEQExpr(paramsOfCall(AttrruleToCall(comp)), ex);
      if (typeof(ex) == KAttracc)
      {
	 attr = ExprToAttracc(ex);
	 if (attridOfAttracc(attr) == atdid &&
	     symbnoOfAttracc(attr) == syntpos)
	    return 1;
      }
   }
   return 0;
}

void
MakeGenTreeDummy(symkey, prodkey, syntpos, line, col)
   DefTableKey symkey, prodkey;
   int syntpos, line, col;
{
   int did;
   Expr ex1, ex2, ex3;

   did = GetDid(KeyInScope(GetAttrScope(symkey, NoEnv), GenAttrId),
		DIDNON);
   ex1 = AttraccToExpr(MkAttracc(syntpos, did, line, col));
   ex2 = ValToExpr(MkVal(0, line, col));
   ex3 = NameToExpr(MkName(TNVOID, line, col));

   UpdateAttrib(prodkey,
		CallToAttrrule(MkCall(
				      ASSIGNFCT,
				      AppFrontSEQExpr(ex1,
						      AppFrontSEQExpr(ex2,
							creatSEQExpr(ex3))),
				      line, col)),
		false);
}/* MakeGenTreeDummy */


int
WriteResults(ds, attr)
   SEQDef ds;
   SEQAttribution attr;
{
   FILE *f;
   AttrEval l;

#ifdef DEBUG
   fprintf(stderr, "WriteResults\n");
#endif
   l = NAttrEval;
   l->defseq = ds;
   l->attrrules = attr;
   f = fopen("liga.out", "w");
   ligaout(f, l);
   fclose(f);

   return (true);
}/* WriteResults */
