
#ifndef PTGNodeFUNCTIONTYPES_H
#define PTGNodeFUNCTIONTYPES_H

#include "eliproto.h"

/* include header file defining PTGNode if ptg_gen is set: */
#define EMPTYptg_genHDR
#ifndef EMPTYHDR
#include "ptg_gen.h"
#endif
#undef EMPTYptg_genHDR

typedef int (*PTGNodeCmpFctType) ELI_ARG((PTGNode, PTGNode));
/* Functions that compare two PTGNode values
 *   If the left argument is less than the right then on exit-
 *     PTGNodeCmpFctType = -1
 *   Else if the arguments are equal then on exit-
 *     PTGNodeCmpFctType = 0
 *   Else on exit-
 *     PTGNodeCmpFctType = 1
 ***/

typedef PTGNode (*PTGNodeMapFct) ELI_ARG((PTGNode));
/* Functions that map one PTGNode value into another
 *   On exit-
 *     PTGNodeMapFct = image of the argument under the map
 ***/

typedef PTGNode (*PTGNodeSumFct) ELI_ARG((PTGNode, PTGNode));
/* Functions that combine two PTGNode values
 *   On exit-
 *     PTGNodeSumFct = combination of the two arguments
 ***/

#endif
