# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.plugins.pigment.widgets.theme import Theme
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.sliced_image import SlicedImageHorizontal
from elisa.plugins.pigment.widgets.list_horizontal import ListHorizontal
from elisa.plugins.poblesec.widgets.menu_item import MenuItemWidget
from elisa.core.utils import notifying_list

class ActionItem:

    def __init__(self, icon, label):
        self.icon = icon
        self.label = label

class SynopsisWidget(Widget):

    def __init__(self):
        super(SynopsisWidget, self).__init__()
        self.initialize()
        self.update_style_properties(self.style.get_items())

    def initialize(self):
        self.title_text = Text()
        self.add(self.title_text)
        self.title_text.visible = True

        self.overview_text = Text()
        self.add(self.overview_text)
        self.overview_text.visible = True

        self.poster_img = Image()
        self.add(self.poster_img)
        self.poster_img.visible = True

        self.actions = notifying_list.List()

        self.actions_list = ListHorizontal(MenuItemWidget, 3)
        self.add(self.actions_list)

        def renderer(item, widget):
            theme = Theme.get_default()
            if item.icon:
                widget.icon.set_from_file(theme.get_resource(item.icon))
            widget.label.label = item.label

        self.actions_list.set_renderer(renderer)
        self.actions_list.set_model(self.actions)
        self._selector = self._create_selector()
        self.actions_list.set_selector(self._selector)

        self.actions_list.visible = True
        self.actions_list.absolute_visible = True
        self._selector.opacity = 255

    def clean(self):
        self.remove(self.title_text)
        self.remove(self.overview_text)
        self.remove(self.poster_img)
        self.remove(self.actions_list)

        self.title_text.clean()
        self.title_text = None

        self.overview_text.clean()
        self.overview_text = None

        self.poster_img.clean()
        self.poster_img = None

        self.actions_list.clean()
        self.actions_list = None

        self._selector = None
        return super(SynopsisWidget, self).clean()

    def do_focus(self, focus):
        if focus:
            self.actions_list.focus = focus

        if focus:
            self._selector.opacity = 255
        else:
            self._selector.opacity = 0

    def _create_selector(self):
        selector = SlicedImageHorizontal()
        theme = Theme.get_default()
        left_cap = theme.get_resource('elisa.plugins.poblesec.selector_left_cap')
        right_cap = theme.get_resource('elisa.plugins.poblesec.selector_right_cap')
        body = theme.get_resource('elisa.plugins.poblesec.selector_body')
        selector.left_cap.set_from_file(left_cap)
        selector.right_cap.set_from_file(right_cap)
        selector.body.set_from_file(body)
        return selector

    def _set_title(self, value):
        self.title_text.label = value

    def _get_title(self):
        return self.title_text.label

    title = property(fget=_get_title, fset=_set_title)

    def _set_overview(self, value):
        self.overview_text.label = value

    def _get_overview(self):
        return self.overview_text.label

    overview = property(fget=_get_overview, fset=_set_overview)

    def _set_poster_path(self, value):
        self._poster_path = value
        self.poster_img.set_from_file(value)

    def _get_poster_path(self):
        return self._poster_path

    poster_path = property(fget=_get_poster_path, fset=_set_poster_path)

class MovieSynopsisWidget(SynopsisWidget):
    # TODO: add more widgets like rating, actors, etc
    pass

class TVEpisodeSynopsisWidget(SynopsisWidget):

    def initialize(self):
        super(TVEpisodeSynopsisWidget, self).initialize()

        self.episode_name_text = Text()
        self.add(self.episode_name_text)
        self.episode_name_text.visible = True

        self.gueststars_text = Text()
        self.add(self.gueststars_text)

    def clean(self):
        self.remove(self.episode_name_text)
        self.episode_name_text.clean()
        self.episode_name_text = None

        self.remove(self.gueststars_text)
        self.gueststars_text.clean()
        self.gueststars_text = None

        return super(TVEpisodeSynopsisWidget, self).clean()

    def _set_guest_stars(self, value):
        self.gueststars_text.markup = value
        if value:
            self.gueststars_text.visible = True

    def _get_guest_stars(self):
        return self.gueststars_text.markup

    guest_stars = property(fget=_get_guest_stars, fset=_set_guest_stars)

    def _set_episode_name(self, value):
        self.episode_name_text.label = value

    def _get_episode_name(self):
        return self.episode_name_text.label

    episode_name = property(fget=_get_episode_name, fset=_set_episode_name)
