# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, build_po


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)


setup(name='elisa-plugin-thetvdb',
    version='0.2',
    description='Retrieve metadata from thetvdb.com',
    long_description="""\
    Lookup for TV shows and get metadata about them (runtime, actors,
    synopsis, posters, etc) using the web-service API available on
    thetvdb.com website.
    """,
    license='GPLv3',
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-http-client', 'elisa-plugin-base'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.conf'],
                  },
    entry_points="""\
    [elisa.core.components.resource_provider]
    TheTvDBResourceProvider = elisa.plugins.thetvdb.resource_provider:TheTvDBResourceProvider

    """,
    cmdclass=cmdclass)
