# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.base_components.theme import Theme
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import common, config
import os


class TestTheme(ElisaTestCase):
    """
    test theme base clasee
    to test : trial elisa.core.tests.test_theme
    """

    def setUp(self):
        ElisaTestCase.setUp(self)
        common.application.plugin_registry.load_plugins()

    def test_get_media(self):
        """
        check get_file_path function
        """
        conf = config.Config('empty.conf')
        test_theme = Theme()
        root_plugin_path = common.application.plugin_registry.get_plugin_path('base')
        config_path = root_plugin_path + '/themes/empty_theme.conf'
        test_theme.config_file = config_path
        image_path = test_theme.get_media('unknown_icon')
        paths = image_path.split('/')
        self.assertEquals(paths[-1], 'unknown.png')
