# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import exception_hook
import sys, os, tempfile

class TestExceptionHook(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._old_hook = sys.excepthook
        
    def tearDown(self):
        sys.excepthook = self._old_hook

    def test_exception_hook_no_display(self):
        sys.excepthook = exception_hook.ExceptionHook(format='text', logdir='/tmp',
                                                      file=sys.stderr, display=False)
        try:
            raise Exception()
        except:
            sys.excepthook.handle()

    def test_exception_hook_display(self):        
        errors = os.tmpfile()
        sys.excepthook = exception_hook.ExceptionHook(format='text', logdir='/tmp',
                                                      file=errors, display=True)
        try:
            raise Exception()
        except:
            sys.excepthook.handle()
            errors.seek(0)
            data = errors.read()
            self.failUnless(data)

        errors.close()

    def test_exception_hook_html(self):        
        errors = os.tmpfile()
        sys.excepthook = exception_hook.ExceptionHook(format='html', logdir='/tmp',
                                                      file=errors, display=True)
        try:
            raise Exception()
        except:
            sys.excepthook.handle()
            errors.seek(0)
            data = errors.read()
            self.failUnless(data)

        errors.close()
