# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.activity import Activity
from elisa.core import common
from elisa.core.bus import bus_message

class DvdPlayerActivity(Activity):

    def get_model(self):
        registry = common.application.plugin_registry
        dvd_player_model = registry.create_component('dvd:dvd_player_model')

        # TODO: make this configurable
        playlist_activity = registry.create_component('base:default_playlist')

        playlist_model = playlist_activity.get_model()
        dvd_player_model.playlist = playlist_model

        dvd_player_model.activity = self

        #msg = bus_message.PlayerModel(dvd_player_model)
        #common.application.bus.send_message(msg)

        return dvd_player_model
