# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import plugin_registry
ElisaControllerClass = plugin_registry.get_component_class('base:elisa_controller')


class ElisaController(ElisaControllerClass):

    supported_models = ('base:elisa_model',)

    default_associations = (
    ('base:menu_model','poblenou:tree_controller'),
    ('base:player_model','base:player_controller'),
    ('dvd:dvd_player_model','dvd:dvd_player_controller'),
    ('base:slideshow_model','base:slideshow_controller')
    )
