from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.plugins.bad.poblenou_frontend.list_cache import substract, \
                                                           cache, \
                                                           insert, \
                                                           remove, \
                                                           update_index, \
                                                           CacheList

class ListCacheTests(ElisaTestCase):

    def testSubstract(self):
        r1 = (10, 20)
        r2 = (15, 25)

        r = substract(r1, r2)
        self.assertEqual(r, (10, 14))
        r = substract(r2, r1)
        self.assertEqual(r, (21, 25))

        r1 = (10, 20)
        r2 = (25, 30)

        r = substract(r1, r2)
        self.assertEqual(r, r1)
        r = substract(r2, r1)
        self.assertEqual(r, r2)

        r1 = (10, 20)
        r2 = (20, 30)

        r = substract(r1, r2)
        self.assertEqual(r, (10, 19))
        r = substract(r2, r1)
        self.assertEqual(r, (21, 30))

        r1 = (10, 10)
        r2 = (10, 20)

        r = substract(r1, r2)
        self.assertEqual(r, None)
        r = substract(r2, r1)
        self.assertEqual(r, (11, 20))

        r1 = (20, 20)
        r2 = (10, 20)

        r = substract(r1, r2)
        self.assertEqual(r, None)
        r = substract(r2, r1)
        self.assertEqual(r, (10, 19))

        r1 = (10, 20)
        r2 = (13, 17)

        self.assertRaises(IndexError, substract, r1, r2)
        r = substract(r2, r1)
        self.assertEqual(r, None)

    def testCachedOdd(self):
        total = 10
        cached = 5
        
        c = cache(total, cached, 3)
        self.assertEqual(c, (1, 5))

        c = cache(total, cached, 0)
        self.assertEqual(c, (0, 2))

        c = cache(total, cached, 1)
        self.assertEqual(c, (0, 3))

        c = cache(total, cached, 9)
        self.assertEqual(c, (7, 9))

        c = cache(total, cached, 8)
        self.assertEqual(c, (6, 9))

        total = 3
        c = cache(total, cached, 0)
        self.assertEqual(c, (0, 2))

        c = cache(total, cached, 1)
        self.assertEqual(c, (0, 2))

        total = 0
        c = cache(total, cached, 5)
        self.assertEqual(c, None)

        c = cache(total, cached, 0)
        self.assertEqual(c, None)


    def testCachedEven(self):
        total = 10
        cached = 4
        
        c = cache(total, cached, 3)
        self.assertEqual(c, (1, 5))

        c = cache(total, cached, 0)
        self.assertEqual(c, (0, 2))

        c = cache(total, cached, 1)
        self.assertEqual(c, (0, 3))

        c = cache(total, cached, 9)
        self.assertEqual(c, (7, 9))

        c = cache(total, cached, 8)
        self.assertEqual(c, (6, 9))


    def testUnitMoveOdd(self):
        total = 10
        cached = 5

        r, a = update_index(total, cached, 2, 3)
        self.assertEqual(r, (0, 0))
        self.assertEqual(a, (5, 5))

        r, a = update_index(total, cached, 3, 4)
        self.assertEqual(r, (1, 1))
        self.assertEqual(a, (6, 6))

        r, a = update_index(total, cached, 0, 1)
        self.assertEqual(r, None)
        self.assertEqual(a, (3, 3))

        r, a = update_index(total, cached, 9, 8)
        self.assertEqual(r, None)
        self.assertEqual(a, (6, 6))

    def testUnitMoveEven(self):
        total = 10
        cached = 2

        r, a = update_index(total, cached, 2, 3)
        self.assertEqual(r, (1, 1))
        self.assertEqual(a, (4, 4))

        r, a = update_index(total, cached, 3, 4)
        self.assertEqual(r, (2, 2))
        self.assertEqual(a, (5, 5))

        r, a = update_index(total, cached, 0, 1)
        self.assertEqual(r, None)
        self.assertEqual(a, (2, 2))

        r, a = update_index(total, cached, 9, 8)
        self.assertEqual(r, None)
        self.assertEqual(a, (7, 7))

    def testMultipleMoveOdd(self):
        total = 40
        cached = 13

        r, a = update_index(total, cached, 10, 30)
        self.assertEqual(r, (4, 16))
        self.assertEqual(a, (24, 36))

        r, a = update_index(total, cached, 20, 25)
        self.assertEqual(r, (14, 18))
        self.assertEqual(a, (27, 31))

        r, a = update_index(total, cached, 0, 5)
        self.assertEqual(r, None)
        self.assertEqual(a, (7, 11))

        r, a = update_index(total, cached, 0, 20)
        self.assertEqual(r, (0, 6))
        self.assertEqual(a, (14, 26))

        r, a = update_index(total, cached, 39, 35)
        self.assertEqual(r, None)
        self.assertEqual(a, (29, 32))

        r, a = update_index(total, cached, 39, 20)
        self.assertEqual(r, (33, 39))
        self.assertEqual(a, (14, 26))

    def testUnitInsertionOdd(self):
        total = 10
        cached = 5

        index = 3
        inserted = 8

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, None)

        inserted = 4

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, 5)

        inserted = 2

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, 1)

        inserted = 0

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, None)

        index = 0
        inserted = 0

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, 2)

        total = 0
        index = 0
        inserted = 0

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, None)

        total = 1
        index = 0
        inserted = 0

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, None)

        total = 4
        index = 0
        inserted = 0

        r = insert(total, cached, index, inserted)
        self.assertEqual(r, 2)

    def testUnitRemovalOdd(self):
        total = 10
        cached = 5

        index = 3
        removed = 8

        r = remove(total, cached, index, removed)
        self.assertEqual(r, None)

        removed = 4

        r = remove(total, cached, index, removed)
        self.assertEqual(r, 5)

        removed = 2

        r = remove(total, cached, index, removed)
        self.assertEqual(r, 1)

        removed = 0

        r = remove(total, cached, index, removed)
        self.assertEqual(r, None)

        index = 0
        removed = 0

        r = remove(total, cached, index, removed)
        self.assertEqual(r, 2)

        total = 0
        index = 0
        removed = 0

        r = remove(total, cached, index, removed)
        self.assertEqual(r, None)

        total = 1
        index = 0
        removed = 0

        r = remove(total, cached, index, removed)
        self.assertEqual(r, None)

        total = 4
        index = 0
        removed = 0

        r = remove(total, cached, index, removed)
        self.assertEqual(r, 2)

    def testCacheListIndexZero(self):
        real = []
        l = CacheList(5, real)

        def generator(i):
            def _pgen():
                return i
            return _pgen

        l.insert(0, generator(2))
        self.assertEqual(real, [2])
        
        l.append(generator(3))
        self.assertEqual(real, [2, 3])

        l.insert(0, generator(1))
        self.assertEqual(real, [1, 2, 3])
        
        l.insert(0, generator(0))
        self.assertEqual(real, [0, 1, 2])

        g = map(lambda i: generator(i), range(4, 10))
        l.extend(g)
        self.assertEqual(real, [0, 1, 2])

        l.pop(0)
        self.assertEqual(real, [1, 2, 3])

        l.pop(2)
        self.assertEqual(real, [1, 2, 4])

        l.pop(3)
        self.assertEqual(real, [1, 2, 4])

    def testCacheListIndexChange(self):
        real = []
        l = CacheList(5, real)

        def generator(i):
            def _pgen():
                return i
            return _pgen

        g = map(lambda i: generator(i), range(10))
        l.extend(g)
        self.assertEqual(real, [0, 1, 2])

        l.current_index = 1
        self.assertEqual(real, [0, 1, 2, 3])

        l.current_index = 2
        self.assertEqual(real, [0, 1, 2, 3, 4])

        l.current_index = 3
        self.assertEqual(real, [1, 2, 3, 4, 5])

        l.current_index = 6
        self.assertEqual(real, [4, 5, 6, 7, 8])

        l.current_index = 7
        self.assertEqual(real, [5, 6, 7, 8, 9])

        l.current_index = 8
        self.assertEqual(real, [6, 7, 8, 9])

        l.current_index = 9
        self.assertEqual(real, [7, 8, 9])
