# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.view import View

from pypgmtools.graph.text import Text
from pypgmtools.graph.image import Image
from pypgmtools.graph.group import Group

import os, pgm

class WeatherPgmView(View):

    """
    This class implements weather view for pgm
    """

    supported_controllers = ('weather:weather_controller')
    default_associations = ()

    def __init__(self):
        View.__init__(self)
        self.context_path = 'pigment:pigment_context'
        self.context_handle = None



    def controller_changed(self):
        pass
        canvas = self.frontend.context.viewport_handle.get_canvas()
#        print "doing it"
#
#

        pos_text_y = canvas.height * 0.87

        self._group = Group(canvas)
        self._group.visible = True
        self._location = Text()
        self._location.bg_color=(0,0,0,0)
        title = self.controller.model.location
        if title == '':
            self._location.label = 'Unknown location'
        else:
            self._location.label = title
        self._location.x = canvas.width * 0.1
        self._location.y = canvas.height * 0.01
        self._location.width = canvas.width * 0.7
        self._location.alignment = pgm.TEXT_ALIGN_CENTER
        self._location.visible = True
        self._group.add(self._location)


        ### Set the Icon
        self._icon = Image()
        icon_path = self.frontend.theme.get_media(self.controller.model.icon,
                                        ('weather:data/%s.png'
                                                % self.controller.model.icon)
                                        )
        self._icon.set_from_fd(os.open(icon_path, os.O_RDONLY))
        self._icon.bg_color = (0,0,0,0)
        self._icon.size = (canvas.width * 0.5, canvas.width * 0.5)
        self._icon.x = canvas.width * 0.2

        self._icon.visible = True
        self._group.add(self._icon)

        ### Set windsock and windspeed
        self._windsock = Image()
        icon_path = self.frontend.theme.get_media('windsock.png' ,
                                        'weather:data/windsock.png')
        self._windsock.set_from_fd(os.open(icon_path, os.O_RDONLY))
        self._windsock.bg_color = (0,0,0,0)
        self._windsock.width = canvas.width * 0.15
        self._windsock.x = canvas.width * 0.1
        self._windsock.y = canvas.height * 0.6
        self._windsock.visible = True
        self._group.add(self._windsock)

        self._windspeed = Text()
        self._windspeed.label = ("%d km/h" % self.controller.model.wind_speed)
        self._windspeed.bg_color = 0,0,0,0
        self._windspeed.x = canvas.width * 0.13
        self._windspeed.y = pos_text_y
        self._windspeed.width = canvas.width * 0.15
        self._windspeed.visible = True
        self._group.add(self._windspeed)


        ### Set humidity and it's image

        self._hydro = Image()
        icon_path = self.frontend.theme.get_media('hydrometer.png' ,
                                        'weather:data/hydrometer.png')
        self._hydro.set_from_fd(os.open(icon_path, os.O_RDONLY))
        self._hydro.bg_color = (0,0,0,0)
        self._hydro.width = canvas.width * 0.15
        self._hydro.x = canvas.width * 0.3
        self._hydro.y = canvas.height * 0.6
        self._hydro.visible = True
        self._group.add(self._hydro)

        self._humi = Text()
        self._humi.label = ("%d %%" % self.controller.model.relHumidity)
        self._humi.bg_color = 0,0,0,0
        self._humi.x = canvas.width * 0.35
        self._humi.y = pos_text_y
        self._humi.width = canvas.width * 0.15
        self._humi.visible = True
        self._group.add(self._humi)

        self._view = Image()
        icon_path = self.frontend.theme.get_media('view.png' ,
                                        'weather:data/view.png')
        self._view.set_from_fd(os.open(icon_path, os.O_RDONLY))
        self._view.bg_color = (0,0,0,0)
        self._view.width = canvas.width * 0.15
        self._view.x = canvas.width * 0.5
        self._view.y = canvas.height * 0.6
        self._view.visible = True
        self._group.add(self._view)

        self._sky = Text()
        self._sky.label = ("%d km" % self.controller.model.view)
        self._sky.bg_color = 0,0,0,0
        self._sky.x = canvas.width * 0.53
        self._sky.y = pos_text_y
        self._sky.width = canvas.width * 0.15
        self._sky.visible = True
        self._group.add(self._sky)

        ## delete this line, if you want to use it inside elisa
        #self.context_handle = self.table

#        self.icon = gtk.Image()
#        pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(
#                                self.frontend.theme.get_media(
#                                        self.controller.model.icon,
#                                        ('weather:data/%s.png'
#                                                % self.controller.model.icon)
#                                    ),
#                                250,
#                                250)
#        self.icon.set_from_pixbuf(pixbuf)
#        self.icon.show()
#        self.table.attach(self.icon,0,2,1,3)
#        self.debug("The icon is: %s and the path is: %s"  %
#                            (self.controller.model.icon,
#                                self.frontend.theme.get_media(
#                                            self.controller.model.icon,
#                                            ('weather:data/%s.png' %
#                                                            self.controller.model.icon
#                                            ))
#                            )
#                        )
#        self.lbl_local_val.set_text(self.controller.model.location)
#        self.lbl_temp_val.set_text("%d °C" %
#                                                    self.controller.model.temp)
#        self.lbl_wspeed_val.set_text("%d km/h" %
#                                                    self.controller.model.wind_speed)
#        self.lbl_windD_val.set_text("%d °" %
#                                                    self.controller.model.wind_dir)
#        self.lbl_hum_val.set_text("%d %%" %
#                                                    self.controller.model.relHumidity)
#        self.lbl_dew_val.set_text("%d °C" %
#                                                    self.controller.model.dew)
#        self.lbl_sky_val.set_text(self.controller.model.sky)
#        self.lbl_press_val.set_text("%d hPa" %
#                                                    self.controller.model.press)
