# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.action import Action
from elisa.core.media_uri import MediaUri
from elisa.core import media_uri, player
from elisa.core import plugin_registry


class PreviewPlayAction(Action):
    """
    Preview a mediafile
    """

    # FIXME: what is it used for ?
    label = 'preview'
    supported_file_types=('audio', 'video')

    # Attribute to set at initialization
    # MediaURI instance
    uri = None
    player_model = None
    erase_playlist = True

    def __call__(self, controller, origin=None):
        """
        @raise TypeError: When action has incorrect parameters
        """
        # FIXME: play preview deactivated 
        return
    
        PlayerModelClass = plugin_registry.get_component_class('base:player_model')
        if isinstance(self.uri, MediaUri) and isinstance(self.player_model,
                                                         PlayerModelClass):
            self.player_model.preview_mode = True
            self.player_model.uri = self.uri
            self.player_model.state = player.STATES.PLAYING
        else:
            raise TypeError("action %s have incorrect parameters" % self.name)
