# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core import common

from twisted.internet import defer

# FIXME: code duplicated from PreviewImageAction

class ViewImageAction(Action):
    """
    DOCME
    """

    label = 'view image'
    supported_file_types = ('image',)

    uri = None
    parent_uri = None
    slideshow_model = None

    def __call__(self, controller, origin=None):
        media_manager = common.application.media_manager

        self.debug("Clean the slideshow_model playlist")
        self.slideshow_model.playlist[:] = []

        def got_media_type(media_type, uri):
            self.debug("%s has been identified as a %s" \
                       % (uri, media_type["file_type"]))
            # only add images to the playlist
            if media_type["file_type"] == "image":
                self.slideshow_model.playlist.append(uri)

        def playlist_ready(result):
            self.debug("Playlist filled with media from %s" % self.parent_uri)
            index = self.slideshow_model.playlist.index(self.uri)
            self.slideshow_model.current_index = index

            self.slideshow_model.preview_mode = False
            self.slideshow_model.playing = False

        def got_children(children):
            self.debug("Listed media from the same directory as %s" % self.uri)
            dfr_list = []
            for child_uri, _ in children:
                dfr = media_manager.get_media_type(child_uri)
                dfr.addCallback(got_media_type, child_uri)
                dfr_list.append(dfr)

            dfr2 = defer.DeferredList(dfr_list)
            dfr2.addCallback(playlist_ready)

        children = []
        dfr = media_manager.get_direct_children(self.parent_uri, children)
        dfr.addCallback(got_children)
