# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

"""
Last reviewed: 07/06/12 by Benjamin
"""

from media_menu_activity import MediaMenuActivity
from elisa.core import common
from elisa.core.media_uri import MediaUri
from elisa.core.observers.list import ListObserver, ListObservable
from elisa.core.media_scanner import MediaEvents
from elisa.core.media_manager import MediaProviderNotFound

from elisa.extern.translation import gettexter, N_

T_ = gettexter('elisa-base')

class AudioActivity(MediaMenuActivity):

    config_doc = {'locations': 'the audio media locations',
                  }

    default_config = {'locations': ['file://./sample_data/music/',],
                      }

    menu_name = T_(N_("Audio"))
    menu_icon_name = "audio"
    media_types = ["audio",]
    xdg_var_name = 'XDG_MUSIC_DIR'

    def initialize(self):
        MediaMenuActivity.initialize(self)

        self._by_artist = self._create_menu_model(T_(N_("Artists")),
                                                  "browse_by_artist")
        self._by_album = self._create_menu_model(T_(N_("Albums")),
                                                 "browse_by_album")
##         self._by_lastadded = self._create_menu_model("Most Recent",
##                                                      "browse_by_last_added")

        # FIXME: should not insert them unless there is something in the
        # collection
        # FIXME: should not append at the of the menu but rather insert next
        # to "Folders"
        self.root_menu.append(self._by_artist)
        self.root_menu.append(self._by_album)
##         self.root_menu.append(self._by_lastadded)

        """
        # Inside Search
        all = self._create_menu_model(T_(N_("All")), "all")
        self._search_artist = self._create_menu_model(T_(N_("By Artist")),
                                                      "search_by_artist")
        self._search_album = self._create_menu_model(T_(N_("By Album")),
                                                     "search_by_album")

        self._search.insert(0, all)
        self._search.append(self._search_artist)
        self._search.append(self._search_album)
        self._search.has_children = True
        """

    def player_model__get(self):
        return self._player_model

    def player_model__set(self, player_model):
        self._player_model = player_model
        mm = common.application.media_manager
        if player_model:
            artist_uri = MediaUri(u'elisa://localhost/artists/')
            self._by_artist.uri = artist_uri
            try:
                has_children = mm.has_children_with_types(artist_uri,
                                                          self.media_types)
            except MediaProviderNotFound, error:
                self.warning(error)
                has_children = False
            self._by_artist.has_children = has_children

            albums_uri = MediaUri(u'elisa://localhost/albums/')
            self._by_album.uri = albums_uri
            try:
                has_children = mm.has_children_with_types(albums_uri,
                                                          self.media_types)
            except MediaProviderNotFound, error:
                self.warning(error)
                has_children = False
            self._by_album.has_children = has_children

##             lastadded_uri = MediaUri(u'elisa://localhost/artists/date_added/')
##             self._by_lastadded.uri = lastadded_uri
##             try:
##                 has_children = mm.has_children_with_types(lastadded_uri,
##                                                           self.media_types)
##             except MediaProviderNotFound, error:
##                 self.warning(error)
##                 has_children = False
##             self._by_lastadded.has_children = has_children
    
    def _create_menu_model(self, text, icon_name, thumbnail_source=None,
                           parent=None):
        audio_icon_name = icon_name
        if parent != None:
            if parent.theme_icon == 'audio_browse_by_artist_icon':
                audio_icon_name = 'artist'
            elif  parent.theme_icon == 'audio_browse_by_album_icon':
                audio_icon_name = 'album'
            
        return MediaMenuActivity._create_menu_model(self, text,
                                                    audio_icon_name,
                                                    thumbnail_source, parent)

    def set_hover_action(self, menu_model, uri, file_type='directory'):
        pass
    
