# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.activity import Activity
from elisa.core import common

class ElisaActivity(Activity):
    """
    """

    def get_model(self):
        registry = common.application.plugin_registry

        # startup model
        elisa_model = registry.create_component('base:elisa_model')
        elisa_model.activity = self

        # player
        player_activity = registry.create_component('base:player_activity')
        player_model = player_activity.get_model()
        player_model.parent = elisa_model
        elisa_model.player = player_model
        
        # dvd player
        dvd_player_activity = registry.create_component('dvd:dvd_player_activity')
        dvd_player_model = dvd_player_activity.get_model()
        dvd_player_model.parent = elisa_model
        elisa_model.dvd_player = dvd_player_model
        
        # slideshow
        slideshow_activity = registry.create_component('base:slideshow_activity')
        slideshow_model = slideshow_activity.get_model()
        slideshow_model.parent = elisa_model
        elisa_model.slideshow = slideshow_model

        # menu
        menu_activity = registry.create_component('base:main_menu_activity')
        menu_activity.player_model = player_model
        menu_activity.dvd_player_model = dvd_player_model
        menu_activity.slideshow_model = slideshow_model
        menu_activity.elisa_model = elisa_model
        menu_model = menu_activity.get_model()
        menu_model.parent = elisa_model
        elisa_model.menu = menu_model

        return elisa_model
