# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.base_components.model import Model
from elisa.core.observers.list import ListObservable


class ListModel(Model, ListObservable):
    """
    Modelize a list data structure

    DOCME more.
    """


    def __init__(self):
        ListObservable.__init__(self)
        Model.__init__(self)

    def append(self, element):
        if isinstance(element, Model):
            element.parent = self
        ListObservable.append(self, element)


    def extend(self, elements):
        for element in elements:
            if isinstance(element, Model):
                element.parent = self
        ListObservable.extend(self, elements)


    def insert(self, position, element):
        if isinstance(element, Model):
            element.parent = self
        ListObservable.insert(self, position, element)


    def pop(self, position=-1):
        element = ListObservable.pop(self, position)
        if isinstance(element, Model):
            element.parent = None


    def remove(self, element):
        ListObservable.remove(self, element)
        if isinstance(element, Model):
            element.parent = None


    def __setitem__(self, key, value):
        previous_value = self[key]
        if isinstance(value, Model):
            value.parent = self
        ListObservable.__setitem__(self, key, value)
        if isinstance(previous_value, Model):
            previous_value.parent = None


    def __delitem__(self, key):
        element = self[key]
        ListObservable.__delitem__(self, key)
        if isinstance(element, Model):
            element.parent = None


    def __setslice__(self, i, j, sequence):
        removed_elements = self[i:j]
        for element in sequence:
            if isinstance(element, Model):
                element.parent = self

        ListObservable.__setslice__(self, i, j, sequence)

        for element in removed_elements:
            if isinstance(element, Model):
                element.parent = None


    def __delslice__(self, i, j):
        removed_elements = self[i:j]
        ListObservable.__delslice__(self, i, j)
        for element in removed_elements:
            if isinstance(element, Model):
                element.parent = None
