# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import common
from elisa.base_components.view import View

import pgm
import tempfile, os

from twisted.internet import defer, reactor

class SlideshowView(View):

    supported_controllers = ('base:slideshow_controller')

    def __init__(self):
        View.__init__(self)
        self.slideshow_widget = None
        self._delay_id = None

        # FIXME: this is a workaround the fact that we are not warned when
        # self.controller.model.playlist changes
        self._playlist = []

    def frontend_changed(self, previous_frontend, new_frontend):
        if new_frontend == None:
            return

        View.frontend_changed(self, previous_frontend, new_frontend)

        if self.slideshow_widget == None:
            canvas = self.frontend.context.viewport_handle.get_canvas()
            self.slideshow_widget = self.SlideshowWidgetClass(canvas,
                                                              pgm.DRAWABLE_MIDDLE)
            self.slideshow_widget.visible = True

            self.context_handle = self.slideshow_widget

            self.slideshow_widget.connect('clicked', self.drag_clicked)
            self.slideshow_widget.connect('drag_begin', self.drag_begin)
            self.slideshow_widget.connect('drag_motion', self.drag_motion)
            self.slideshow_widget.connect('drag_end', self.drag_end)

    def controller_changed(self):
        self.slideshow_widget.duration = self.controller.model.duration

    def attribute_set(self, key, old_value, new_value):
        if key == 'current_index':
            if self._delay_id != None and self._delay_id.active():
                self._delay_id.cancel()
            # update paths to the pictures in the slideshow widget
            # FIXME: this is a hack and should actually only be done when
            # playlist's content changes; it is also quite inefficient.
            #paths = map(lambda uri: uri.path, self.controller.model.playlist)
            #self.slideshow_widget.pictures_paths = paths

            if self._playlist != self.controller.model.playlist:
                # copy the original playlist model locally
                self._playlist = []
                for picture in self.controller.model.playlist:
                    self._playlist.append(picture)

                # update paths to the pictures in the slideshow widget
                size = len(self._playlist)
                self.slideshow_widget.pictures_paths = [""]*size
                i = 0
                for uri in self._playlist:
                    self._set_thumbnail_path(uri, i)
                    i += 1

            # update the path for the current item
            uri = self._playlist[new_value]

            def load_full_size(path):
                # FIXME: should wait until the thumbnail has been loaded
                self.debug("slideshow path at index %s set to %s" \
                           % (new_value, path))
                self.slideshow_widget.set_path_for_index(new_value, path)
            
            dfr = self._get_local_path(uri)
            self._delay_id = reactor.callLater(1.0, dfr.addCallback,
                                               load_full_size)

            # update the index in the slideshow widget
            self.slideshow_widget.current_index = new_value

        elif key == 'duration':
            self.slideshow_widget.duration = new_value

    def _get_local_path(self, uri):
        media_manager = common.application.media_manager
        uri = media_manager.get_real_uri(uri)

        if uri.scheme == 'file':
            dfr_open = defer.Deferred()
            path = uri.path
            dfr_open.callback(path)
        else:
            # FIXME: locally cache the picture if it is not a local file; that
            # should be the job of the media_manager
            def read(data, handle):
                fd, path = tempfile.mkstemp(prefix="elisa_",
                                            suffix="_%s" % uri.extension)
                self.debug("caching full resolution image to %s", path)
                os.write(fd, data)
                os.close(fd)
                handle.close()
                return path

            def opened(handle):
                if handle != None:
                    dfr_read = handle.read()
                    dfr_read.addCallback(read, handle)

                return dfr_read

            self.debug("downloading full resolution image from %s" % uri)
            dfr_open = media_manager.open(uri)
            dfr_open.addCallback(opened)

        return dfr_open

    def _set_thumbnail_path(self, uri, index):
        def error(error):
            try:
                error.raiseException()
            except Exception, e:
                self.info(e)

        def success(result, index):
            if result is not None:
                self.debug("slideshow path at index %s set to %s" \
                           % (index, result[0]))
                self.slideshow_widget.set_path_for_index(index, result[0])

        dfr = common.application.thumbnailer.get_thumbnail(uri, 256, "image")
        dfr.addErrback(error).addCallback(success, index)


    def drag_begin(self, drawable, x, y, z, button, time):
        return False
           
    def drag_end(self, drawable, x, y, z, button, time):
        return False

    def drag_motion(self, drawable, x, y, z, button, time):
        return False

    def drag_clicked(self, drawable, x, y, z, button, time):
        return False
