# Elisa - Home multimedia server
# Copyright (C) 2006 Fluendo, S.A. (www.fluendo.com).
# All rights reserved.
# 
# This software is available under three license agreements.
# 
# There are various plugins and extra modules for Elisa licensed
# under the MIT license. For instance our upnp module uses this license.
# 
# The core of Elisa is licensed under GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special 
# exception to use Elisa with Fluendo's plugins.
# 
# The GPL part is also available under a commerical licensing
# agreement.
# 
# The second license is the Elisa Commercial License Agreement.
# This license agreement is available to licensees holding valid
# Elisa Commercial Agreement licenses.
# See "LICENSE.Elisa" in the root of this distribution.

import sys
import os
from elisa.core import __version__, log
from elisa.core.utils.dist import build_po
from elisa.core.utils.i18n import compile_translations_from_file

import setuptools
from pkg_resources import *
from setuptools import setup, find_packages

from setuptools.command import test
from setuptools.command import install
from setuptools.command import build_py

from twisted.scripts import trial

log.init()

def override_check_test_suite(dist, attr, value):
    if not isinstance(value, list):
        raise DistutilsSetupError("test_suite must be a list")
    
setuptools.dist.check_test_suite = override_check_test_suite

class LocaleBuildPy(build_py.build_py):
    """
    create .mo files from .po locales if needed
    """
 
    def run(self):
        pobuild = build_po(self.distribution)
        pobuild.run()
        build_py.build_py.run(self)

class TrialTest(test.test):
    """
    Twisted Trial setuptools command
    """

    user_options = test.test.user_options + [
        ('coverage','c', "Report coverage data"),
    ]

    def initialize_options(self):
        test.test.initialize_options(self)
        self.coverage = None

    def finalize_options(self):
        if self.test_suite is None:
            if self.test_module is None:
                self.test_suite = self.distribution.test_suite
            else:
                self.test_suite = self.test_module+".test_suite"
        elif self.test_module:
            raise DistutilsOptionError(
                "You may specify a module or a suite, but not both"
            )

        self.test_args = self.test_suite
    
    def run_tests(self):
        config = trial.Options()
        config.parseOptions()
        config['tests'] = self.test_args

        if self.coverage:
            config.opt_coverage()
        
        trial._initialDebugSetup(config)
        trialRunner = trial._makeRunner(config)
        suite = trial._getSuite(config)

        # run the tests
        if config['until-failure']:
            test_result = trialRunner.runUntilFailure(suite)
        else:
            test_result = trialRunner.run(suite)

        # write coverage data
        if config.tracer:
            sys.settrace(None)
            results = config.tracer.results()
            results.write_results(show_missing=1, summary=False,
                                  coverdir=config.coverdir)

data_files = []
if sys.platform == 'linux2':
    data_files.extend([('share/pixmaps', ['data/elisa.png']),
                       ('share/applications', ['data/elisa.desktop'])])


setup(cmdclass={'test': TrialTest, 'build_py': LocaleBuildPy },
      data_files=data_files,
      name="elisa",
      version=__version__,
      description="""Fluendo Media Center""",
      author="The Elisa Team",
      author_email="",
      maintainer="Philippe Normand",
      maintainer_email="philippe@fluendo.com",
      long_description="""\
Elisa is an open media center system to watch, listen, manage and
share videos, files and music. It uses GStreamer, Python and OpenGL
technologies. """,
      url="http://elisa.fluendo.com",
      keywords=['multimedia', 'gstreamer', 'opengl'],
      classifiers = ['Development Status :: 3 - Alpha',
                     'Environment :: X11 Applications',
                     'Intended Audience :: End Users/Desktop',
                     'Natural Language :: English',
                     'Operating System :: OS Independent',
                     'Programming Language :: Python',
                     'Topic :: Multimedia :: Graphics :: 3D Rendering',
                     'Topic :: Multimedia :: Sound/Audio',
                     'Topic :: Multimedia :: Video',
                     ],
      test_suite = ['elisa',],
      zip_safe = False,
      packages=find_packages(),
      include_package_data = True,
      entry_points="""
      [gui_scripts]
      elisa = elisa.core.application:main

      [elisa.plugins]
      base = elisa.plugins.base
      
      # Good Bundle
      services_good = elisa.plugins.good.services_good
      theme_switcher = elisa.plugins.good.theme_switcher
      aspect_ratio_switcher = elisa.plugins.good.aspect_ratio_switcher
      input_good = elisa.plugins.good.input_good
      coherence_plugin = elisa.plugins.good.coherence_plugin
      media_good = elisa.plugins.good.media_good
      audiocd = elisa.plugins.good.audiocd
      fspot = elisa.plugins.good.fspot
      hal = elisa.plugins.good.hal
      pigment = elisa.plugins.good.pigment.pigment:PigmentPlugin
      testing = elisa.plugins.good.testing

      # Ugly Bundle
      flickr = elisa.plugins.ugly.flickr
      media_ugly = elisa.plugins.ugly.media_ugly

      # Bad Bundle
      gtk = elisa.plugins.bad.gtk_frontend
      poblenou = elisa.plugins.bad.poblenou_frontend
      classic = elisa.plugins.bad.classic_frontend
      dvd = elisa.plugins.bad.dvd
      stage6 = elisa.plugins.bad.stage6
      weather = elisa.plugins.bad.weather
      input_bad = elisa.plugins.bad.input_bad
      media_bad = elisa.plugins.bad.media_bad
      rhythmbox = elisa.plugins.bad.rhythmbox
      
      service = elisa.plugins.service

      [distutils.commands]
      build_po = elisa.core.utils.dist:build_po
      
      [distutils.setup_keywords]
      elisa_infos = elisa.core.utils.dist:assert_dict_or_none

      [egg_info.writers]
      elisa_infos.txt = elisa.core.utils.dist:write_dict
      """,
    )
