;--------------------------------
;Include Modern UI

  !include "MUI.nsh"
  !include "make_env.nsh"
;--------------------------------
;General

  ;Name and file
  Name "Elisa Media Center setup"
  OutFile "elisa_setup.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\Elisa"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\Elisa" ""

;--------------------------------
;Interface Configuration

  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Header\nsis.bmp" ; optional
  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_LICENSE "..\LICENSE.GPL"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

    !define MUI_FINISHPAGE_NOAUTOCLOSE
    !define MUI_FINISHPAGE_RUN
    !define MUI_FINISHPAGE_RUN_CHECKED
    !define MUI_FINISHPAGE_RUN_TEXT "Start Elisa Media Center"
    !define MUI_FINISHPAGE_RUN_FUNCTION "LaunchElisa"
;    !define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
;    !define MUI_FINISHPAGE_SHOWREADME $INSTDIR\readme.txt
  !insertmacro MUI_PAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "Elisa Media Center" SecElisa

  SetOutPath "$INSTDIR"
  
  File /r distelisa\*.*

  !define ALL_USERS
  StrCpy $R1 "GST_PLUGIN_PATH"
  ReadEnvStr $R0 $R1
  StrCpy $R0 "$R0;$INSTDIR;"  
  Push $R1
  Push $R0
  Call WriteEnvStr

  StrCpy $R1 "PATH"
  ReadEnvStr $R0 $R1
  StrCpy $R0 "$R0;$INSTDIR;"
  Push $R1
  Push $R0
  Call WriteEnvStr

  
  SetShellVarContext current
  StrCpy $0 $SMPROGRAMS
  CreateDirectory "$0\Elisa Media Center"
  CreateShortCut "$0\Elisa Media Center\Elisa Media Center.lnk" "$INSTDIR\elisa.exe"
  CreateShortCut "$0\Elisa Media Center\Uninstall.lnk" "$INSTDIR\Uninstall.exe"

  ;Store installation folder
  WriteRegStr HKCU "Software\Elisa" "" $INSTDIR
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
;Descriptions

  ;Language strings
  LangString DESC_SecElisa ${LANG_ENGLISH} "Elisa program files."

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecElisa} $(DESC_SecElisa)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ;ADD YOUR OWN FILES HERE...
  SetShellVarContext current
  StrCpy $0 $SMPROGRAMS

  Delete "$0\Elisa Media Center\Elisa Media Center.lnk"
  Delete "$0\Elisa Media Center\Uninstall.lnk"

  RMDir "$0\Elisa Media Center"

  Delete "$INSTDIR\Uninstall.exe"

  RMDir /r "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Elisa"

SectionEnd

Function LaunchElisa
  ExecShell "" "$INSTDIR\elisa.exe"
FunctionEnd