#ifndef __MAILREADER_H__
#define __MAILREADER_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002 bazyl
   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void mailreader_init (void);
extern void mailreader_free_resources (void);
extern void mailreader_refresh (void);
extern void mailreader_redraw (void);
extern void mailreader_set_focus (void);
extern void mailreader_unset_focus (void);

extern void mailreader_change_mime (mail_t *mail, mime_t *mime);

/** close this window */
extern void mailreader_close (void);
/** scroll up */
extern void mailreader_line_up (void);
/** scroll down */
extern void mailreader_line_down (void);
/** scroll page up */
extern void mailreader_page_up (void);
/** scroll page down */
extern void mailreader_page_down (void);
/** move to the top */
extern void mailreader_top (void);
/** move to the bottom */
extern void mailreader_bottom (void);
/** toggle display mode (header / message) */
extern void mailreader_header_switch (void);
/** open message window */
extern void mailreader_show (void);
/** load selected message to mailreader window */
extern void mailreader_load (void);
/** search forward */
extern void mailreader_search_forward (void);
/** search backward */
extern void mailreader_search_backward (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER mailreader.h
 *
 ****************************************************************************/
#endif
