**Elvish** is a friendly interactive shell and an expressive programming
language. It runs on Linux, BSDs, macOS and Windows.

<div id="no-js">
  <h1>Demos</h1>
  <p>
    Enable JavaScript to see demos as slides.
  </p>
</div>

<ul id="demo-switcher">
</ul>

<div id="demo-window"> <div id="demo-container" class="expanded">
  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Powerful Pipelines</h2>
      <p>
        Text pipelines are intuitive and powerful. However, if your data have
        inherently complex structures, processing them with the pipeline
        often requires a lot of ad-hoc, hard-to-maintain text processing code.
      </p>
      <p>
        Pipelines in Elvish can carry structured data, not just text. You can
        stream lists, maps and even functions through the pipeline.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot pipelines
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Intuitive Control Structures</h2>
      <p>
        If you know programming, you probably already know how
        <code>if</code> looks in C. So why learn another syntax?
      </p>
      <p>
        Elvish comes with a standard set of control structures: conditional
        control with <code>if</code>, loops with <code>for</code> and
        <code>while</code>, and exception handling with <code>try</code>. All
        of them have a familiar C-like syntax.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot control-structures
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Directory History</h2>
      <p>
        Do you type far too many <code>cd</code> commands? Do you struggle to
        remember which <code>deeply/nested/directory</code> your source codes,
        logs and configuration files are?
      </p>
      <p>
        Backed by a real database, Elvish remembers all the directories you
        have been to, all the time. Just press <span class="key">Ctrl-L</span>
        and search, as you do in a browser.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot location-mode
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Command History</h2>
      <p>
        Want to find the magical <code>ffmpeg</code> command that you used to
        transcode a video file two months ago, but it is buried under a
        million other commands?
      </p>
      <p>
        No more cycling through history one command at a time.
        Press <span class="key">Ctrl-R</span> and start searching your entire
        command history.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot histlist-mode
    </div>
  </div> </div>

  <div class="demo-wrapper"> <div class="demo">
    <div class="demo-col demo-description">
      <h2>Built-in File Manager</h2>
      <p>
        Want the convenience of a file manager, but can't give up the power of
        a shell?
      </p>
      <p>
        You no longer have to make a choice. Press <span
        class="key">Ctrl-N</span> to start exploring directories and
        preview files, with the full power of a shell still under your
        fingertip.
      </p>
    </div>
    <div class="demo-col demo-ttyshot">
      @ttyshot navigation-mode
    </div>
  </div> </div>
</div> </div>

<div id="columns">

<div class="column">

# <i class="icon-rocket"></i> Run Elvish

-   [Download](get/) a binary

-   [Source code](https://github.com/elves/elvish) on GitHub

-   [Try Elvish](https://try.elv.sh) directly from the browser (coming soon!)

# <i class="icon-sitemap"></i> Use this Site

Start your Elvish journey in this very website!

-   [Learn](learn/) the fundamentals and interesting topics

-   Peruse the definitive [reference](ref/) documents

-   Read the [blog](blog/) for news, tips, and developers' musings

-   Subscribe to the [feed](feed.atom) to keep updated

</div>

<div class="column">

# <i class="icon-chat"></i> Join the Community

Join any of the following channels -- they are all all bridged together thanks
to [matterbridge](https://github.com/42wim/matterbridge)!

-   IRC: [#elvish](https://webchat.freenode.net/?channels=elvish) on Freenode

-   Gitter: [elves/elvish](https://gitter.im/elves/elvish)

-   Telegram: [@elvish](https://telegram.me/elvish)

-   Matrix: [#elvish:matrix.org](https://matrix.to/#/#elvish:matrix.org)

# <i class="icon-link-ext"></i> More Resources

-   [Awesome Elvish](https://github.com/elves/awesome-elvish): Official list of
    unofficial Elvish modules

-   [@RealElvishShell](https://twitter.com/realelvishshell) on Twitter

</div>

</div>
